/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.ss.reader.AbstractSpreadsheetReader;
import io.github.millij.poi.util.Beans;
import io.github.millij.poi.util.Spreadsheet;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsReader
extends AbstractSpreadsheetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlsReader.class);

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsReader :: Invalid bean type passed !");
        }
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            int sheetCount = wb.getNumberOfSheets();
            LOGGER.debug("Total no. of sheets found in HSSFWorkbook : #{}", (Object)sheetCount);
            for (int i = 0; i < sheetCount; ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                LOGGER.debug("Processing HSSFSheet at No. : {}", (Object)i);
                this.processSheet(beanClz, sheet, 0, listener);
            }
            wb.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading HSSFSheet, to %s : %s", beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, int sheetNo, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsReader :: Invalid bean type passed !");
        }
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            HSSFSheet sheet = wb.getSheetAt(sheetNo);
            this.processSheet(beanClz, sheet, 0, listener);
            wb.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet %d, to %s : %s", sheetNo, beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    protected <T> void processSheet(Class<T> beanClz, HSSFSheet sheet, int headerRowNo, RowListener<T> eventHandler) {
        HSSFRow headerRow = sheet.getRow(headerRowNo);
        Map<Integer, String> headerMap = this.extractCellHeaderMap(headerRow);
        Map<String, String> cellPropMapping = Spreadsheet.getColumnToPropertyMap(beanClz);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Map<String, Object> rowDataMap;
            HSSFRow row = (HSSFRow)rows.next();
            int rowNum = row.getRowNum();
            if (rowNum == 0 || (rowDataMap = this.extractRowDataAsMap(row, headerMap)) == null || rowDataMap.isEmpty()) continue;
            T rowBean = Spreadsheet.rowAsBean(beanClz, cellPropMapping, rowDataMap);
            eventHandler.row(rowNum, rowBean);
        }
    }

    private Map<Integer, String> extractCellHeaderMap(HSSFRow headerRow) {
        if (headerRow == null) {
            return new HashMap<Integer, String>();
        }
        HashMap<Integer, String> cellHeaderMap = new HashMap<Integer, String>();
        Iterator cells = headerRow.cellIterator();
        while (cells.hasNext()) {
            HSSFCell cell = (HSSFCell)cells.next();
            int cellCol = cell.getColumnIndex();
            switch (cell.getCellTypeEnum()) {
                case STRING: {
                    cellHeaderMap.put(cellCol, cell.getStringCellValue());
                    break;
                }
                case NUMERIC: {
                    cellHeaderMap.put(cellCol, String.valueOf(cell.getNumericCellValue()));
                    break;
                }
                case BOOLEAN: {
                    cellHeaderMap.put(cellCol, String.valueOf(cell.getBooleanCellValue()));
                    break;
                }
                case FORMULA: 
                case BLANK: 
                case ERROR: {
                    break;
                }
            }
        }
        return cellHeaderMap;
    }

    private Map<String, Object> extractRowDataAsMap(HSSFRow row, Map<Integer, String> columnHeaderMap) {
        if (row == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            HSSFCell cell = (HSSFCell)cells.next();
            int cellCol = cell.getColumnIndex();
            String cellColName = columnHeaderMap.get(cellCol);
            switch (cell.getCellTypeEnum()) {
                case STRING: {
                    rowDataMap.put(cellColName, cell.getStringCellValue());
                    break;
                }
                case NUMERIC: {
                    rowDataMap.put(cellColName, cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    rowDataMap.put(cellColName, cell.getBooleanCellValue());
                    break;
                }
                case FORMULA: 
                case BLANK: 
                case ERROR: {
                    break;
                }
            }
        }
        return rowDataMap;
    }
}

