/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface SpreadsheetReader {
    public <T> void read(Class<T> var1, InputStream var2, RowListener<T> var3) throws SpreadsheetReadException;

    default public <T> void read(Class<T> beanClz, File file, RowListener<T> listener) throws SpreadsheetReadException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.read(beanClz, (InputStream)fis, listener);
        }
        catch (IOException ex) {
            String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    public <T> void read(Class<T> var1, InputStream var2, int var3, RowListener<T> var4) throws SpreadsheetReadException;

    default public <T> void read(Class<T> beanClz, File file, int sheetNo, RowListener<T> listener) throws SpreadsheetReadException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.read(beanClz, fis, sheetNo, listener);
        }
        catch (IOException ex) {
            String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    public <T> List<T> read(Class<T> var1, InputStream var2) throws SpreadsheetReadException;

    default public <T> List<T> read(Class<T> beanClz, File file) throws SpreadsheetReadException {
        List<T> list;
        FileInputStream fis = new FileInputStream(file);
        try {
            list = this.read(beanClz, fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
                throw new SpreadsheetReadException(errMsg, ex);
            }
        }
        ((InputStream)fis).close();
        return list;
    }

    public <T> List<T> read(Class<T> var1, InputStream var2, int var3) throws SpreadsheetReadException;

    default public <T> List<T> read(Class<T> beanClz, File file, int sheetNo) throws SpreadsheetReadException {
        List<T> list;
        FileInputStream fis = new FileInputStream(file);
        try {
            list = this.read(beanClz, (InputStream)fis, sheetNo);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                String errMsg = String.format("Failed to read file as Stream : %s", ex.getMessage());
                throw new SpreadsheetReadException(errMsg, ex);
            }
        }
        ((InputStream)fis).close();
        return list;
    }

    public void read(InputStream var1, RowListener<Map<String, Object>> var2) throws SpreadsheetReadException;

    public void read(InputStream var1, int var2, RowListener<Map<String, Object>> var3) throws SpreadsheetReadException;

    public List<Map<String, Object>> read(InputStream var1) throws SpreadsheetReadException;

    public List<Map<String, Object>> read(InputStream var1, int var2) throws SpreadsheetReadException;
}

