/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.ss.model.Column;
import io.github.millij.poi.ss.reader.AbstractSpreadsheetReader;
import io.github.millij.poi.util.Beans;
import io.github.millij.poi.util.Spreadsheet;
import io.github.millij.poi.util.Strings;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsReader
extends AbstractSpreadsheetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlsReader.class);

    public XlsReader() {
        this(0);
    }

    public XlsReader(int headerRowIdx) {
        this(headerRowIdx, Integer.MAX_VALUE);
    }

    public XlsReader(int headerRowIdx, int lastRowIdx) {
        super(headerRowIdx, lastRowIdx);
    }

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsReader :: Invalid bean type passed !");
        }
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            int sheetCount = wb.getNumberOfSheets();
            LOGGER.debug("Total no. of sheets found in HSSFWorkbook : #{}", (Object)sheetCount);
            for (int i = 0; i < sheetCount; ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                LOGGER.debug("Processing HSSFSheet at No. : {}", (Object)i);
                this.processSheet(beanClz, sheet, listener);
            }
            wb.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading HSSFSheet, to %s : %s", beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, int sheetNo, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsReader :: Invalid bean type passed !");
        }
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            HSSFSheet sheet = wb.getSheetAt(sheetNo - 1);
            this.processSheet(beanClz, sheet, listener);
            wb.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet %d, to %s : %s", sheetNo, beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public void read(InputStream is, RowListener<Map<String, Object>> listener) throws SpreadsheetReadException {
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            int sheetCount = wb.getNumberOfSheets();
            LOGGER.debug("Total no. of sheets found in HSSFWorkbook : #{}", (Object)sheetCount);
            for (int i = 0; i < sheetCount; ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                LOGGER.debug("Processing HSSFSheet at No. : {}", (Object)i);
                this.processSheet(sheet, listener);
            }
            wb.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading HSSFSheet, to Map : %s", ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public void read(InputStream is, int sheetNo, RowListener<Map<String, Object>> listener) throws SpreadsheetReadException {
        try {
            HSSFWorkbook wb = new HSSFWorkbook(is);
            HSSFSheet sheet = wb.getSheetAt(sheetNo - 1);
            this.processSheet(sheet, listener);
            wb.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet %d, to Map : %s", sheetNo, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    protected void processSheet(HSSFSheet sheet, RowListener<Map<String, Object>> eventHandler) {
        HSSFRow headerRowObj = sheet.getRow(this.headerRowIdx);
        Map<String, String> headerCellRefsMap = this.asHeaderNameToCellRefMap(headerRowObj, false);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Map<String, Object> rowDataMap;
            HSSFRow row = (HSSFRow)rows.next();
            int rowNum = row.getRowNum();
            if (rowNum < this.headerRowIdx || rowNum > this.lastRowIdx || (rowDataMap = this.extractRowDataAsMap(row)) == null || rowDataMap.isEmpty()) continue;
            Map<String, Object> rowBean = Spreadsheet.rowAsMap(headerCellRefsMap, rowDataMap);
            eventHandler.row(rowNum, rowBean);
        }
    }

    protected <T> void processSheet(Class<T> beanClz, HSSFSheet sheet, RowListener<T> eventHandler) {
        HSSFRow headerRowObj = sheet.getRow(this.headerRowIdx);
        Map<String, String> headerCellRefsMap = this.asHeaderNameToCellRefMap(headerRowObj, true);
        Map<String, Column> propColumnMap = Spreadsheet.getPropertyToColumnDefMap(beanClz);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Map<String, Object> rowDataMap;
            HSSFRow row = (HSSFRow)rows.next();
            int rowNum = row.getRowNum();
            if (rowNum < this.headerRowIdx || rowNum > this.lastRowIdx || (rowDataMap = this.extractRowDataAsMap(row)) == null || rowDataMap.isEmpty()) continue;
            T rowBean = Spreadsheet.rowAsBean(beanClz, propColumnMap, headerCellRefsMap, rowDataMap);
            eventHandler.row(rowNum, rowBean);
        }
    }

    private Map<String, String> asHeaderNameToCellRefMap(HSSFRow headerRow, boolean normalizeHeaderName) {
        if (Objects.isNull(headerRow)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headerCellRefs = new HashMap<String, String>();
        Iterator cells = headerRow.cellIterator();
        while (cells.hasNext()) {
            HSSFCell cell = (HSSFCell)cells.next();
            int cellColIdx = cell.getColumnIndex();
            String cellColRef = String.valueOf(cellColIdx);
            Object header = this.getCellValue(cell);
            String rawHeaderName = Objects.isNull(header) ? "" : String.valueOf(header);
            String headerName = normalizeHeaderName ? Strings.normalize(rawHeaderName) : rawHeaderName;
            headerCellRefs.put(headerName, cellColRef);
        }
        return headerCellRefs;
    }

    private Map<String, Object> extractRowDataAsMap(HSSFRow row) {
        if (row == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            HSSFCell cell = (HSSFCell)cells.next();
            int cellColIdx = cell.getColumnIndex();
            String cellColRef = String.valueOf(cellColIdx);
            Object cellVal = this.getCellValue(cell);
            rowDataMap.put(cellColRef, cellVal);
        }
        return rowDataMap;
    }

    private Object getCellValue(HSSFCell cell) {
        Object cellVal;
        if (Objects.isNull(cell)) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: {
                cellVal = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                cellVal = cell.getNumericCellValue();
                break;
            }
            case BOOLEAN: {
                cellVal = cell.getBooleanCellValue();
                break;
            }
            default: {
                cellVal = null;
            }
        }
        return cellVal;
    }
}

