/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.util;

import io.github.millij.poi.ss.model.DateTimeType;
import io.github.millij.poi.util.Strings;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Beans {
    private static final Logger LOGGER = LoggerFactory.getLogger(Beans.class);
    private static final PropertyUtilsBean PROP_UTILS_BEAN = new PropertyUtilsBean();
    private static final ConvertUtilsBean CONVERT_UTILS_BEAN = new ConvertUtilsBean();

    private Beans() {
    }

    public static String getFieldName(Method method) {
        String methodName;
        return Introspector.decapitalize(methodName.substring((methodName = method.getName()).startsWith("is") ? 2 : 3));
    }

    public static String getFieldValueAsString(Object beanObj, String fieldName) throws Exception {
        PropertyDescriptor pd = PROP_UTILS_BEAN.getPropertyDescriptor(beanObj, fieldName);
        Method getterMtd = pd.getReadMethod();
        Object value = getterMtd.invoke(beanObj, new Object[0]);
        String cellValue = Objects.nonNull(value) ? String.valueOf(value) : null;
        return cellValue;
    }

    public static boolean isInstantiableType(Class<?> clz) {
        if (Objects.isNull(clz)) {
            return false;
        }
        int modifiers = clz.getModifiers();
        LOGGER.debug("Modifiers of Class : {} - {}", clz, (Object)modifiers);
        return !clz.isPrimitive() && !Modifier.isAbstract(modifiers) && !clz.isInterface() && !clz.isArray();
    }

    public static Object getProperty(Object bean, String propName) throws Exception {
        Object value = PROP_UTILS_BEAN.getSimpleProperty(bean, propName);
        return value;
    }

    public static void setProperty(Object target, String propName, Class<?> propType, Object propValue) throws Exception {
        if (Objects.isNull(propValue)) {
            return;
        }
        try {
            Converter converter;
            Object newValue = propValue instanceof String ? CONVERT_UTILS_BEAN.convert((String)propValue, propType) : ((converter = CONVERT_UTILS_BEAN.lookup(propType)) != null ? converter.convert(propType, propValue) : propValue);
            PROP_UTILS_BEAN.setProperty(target, propName, newValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setProperty(Object target, String propName, Object propValue, String format, DateTimeType dateTimeType) throws Exception {
        if (Objects.isNull(propValue)) {
            return;
        }
        PropertyDescriptor descriptor = PROP_UTILS_BEAN.getPropertyDescriptor(target, propName);
        if (Objects.isNull(descriptor) || Objects.isNull(descriptor.getWriteMethod())) {
            return;
        }
        Class<?> propType = descriptor.getPropertyType();
        if (!DateTimeType.NONE.equals((Object)dateTimeType) || propType.equals(Date.class)) {
            Beans.setDateTimeProperty(target, propName, propType, propValue, format, dateTimeType);
            return;
        }
        if (propType.isEnum() && propValue instanceof String) {
            String cleanEnumStr = Strings.normalize((String)propValue).toUpperCase();
            Object enumValue = Enum.valueOf(propType, cleanEnumStr);
            Beans.setProperty(target, propName, propType, enumValue);
            return;
        }
        if (propType.equals(Boolean.class) && propValue instanceof String) {
            String cleanBoolStr = Strings.normalize((String)propValue);
            Beans.setProperty(target, propName, propType, cleanBoolStr);
            return;
        }
        Beans.setProperty(target, propName, propType, propValue);
    }

    private static void setDateTimeProperty(Object target, String propName, Class<?> propType, Object propValue, String format, DateTimeType dateTimeType) throws Exception {
        String dateFormatStr = Objects.isNull(format) || format.isBlank() ? "dd/MM/yyyy" : format;
        SimpleDateFormat dateFmt = new SimpleDateFormat(dateFormatStr);
        Date dateValue = dateFmt.parse((String)propValue);
        if (propType.equals(Date.class)) {
            Beans.setProperty(target, propName, propType, dateValue);
        } else {
            Long longValue;
            if (DateTimeType.DURATION.equals((Object)dateTimeType)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateValue);
                long durationMillis = calendar.get(11) * 3600000 + calendar.get(12) * 60000 + calendar.get(13) * 1000;
                longValue = durationMillis;
            } else {
                longValue = dateValue.getTime();
            }
            Beans.setProperty(target, propName, propType, longValue);
        }
    }
}

