/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowContentsAsMapHandler;
import io.github.millij.poi.ss.handler.RowContentsHandler;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.ss.reader.AbstractSpreadsheetReader;
import io.github.millij.poi.util.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XlsxReader
extends AbstractSpreadsheetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlsxReader.class);

    public XlsxReader() {
        this(0);
    }

    public XlsxReader(int headerRowIdx) {
        this(headerRowIdx, Integer.MAX_VALUE);
    }

    public XlsxReader(int headerRowIdx, int lastRowIdx) {
        super(headerRowIdx, lastRowIdx);
    }

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsxReader :: Invalid bean type passed !");
        }
        try (OPCPackage opcPkg = OPCPackage.open((InputStream)is);){
            XSSFReader xssfReader = new XSSFReader(opcPkg);
            XMLReader xmlReader = this.newXMLReaderInstance(beanClz, opcPkg, xssfReader, listener);
            XSSFReader.SheetIterator worksheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (worksheets.hasNext()) {
                InputStream sheetInpStream = worksheets.next();
                String sheetName = worksheets.getSheetName();
                LOGGER.debug("Reading XLSX Sheet :: ", (Object)sheetName);
                xmlReader.parse(new InputSource(sheetInpStream));
                sheetInpStream.close();
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet data, to Bean %s : %s", beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public <T> void read(Class<T> beanClz, InputStream is, int sheetNo, RowListener<T> listener) throws SpreadsheetReadException {
        if (!Beans.isInstantiableType(beanClz)) {
            throw new IllegalArgumentException("XlsxReader :: Invalid bean type passed !");
        }
        try (OPCPackage opcPkg = OPCPackage.open((InputStream)is);){
            XSSFReader xssfReader = new XSSFReader(opcPkg);
            XMLReader xmlReader = this.newXMLReaderInstance(beanClz, opcPkg, xssfReader, listener);
            XSSFReader.SheetIterator worksheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int i = 1;
            while (worksheets.hasNext()) {
                InputStream sheetInpStream = worksheets.next();
                String sheetName = worksheets.getSheetName();
                if (i == sheetNo) {
                    LOGGER.debug("Reading XLSX Sheet :: #{} - {}", (Object)i, (Object)sheetName);
                    xmlReader.parse(new InputSource(sheetInpStream));
                    sheetInpStream.close();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet %d, to Bean %s : %s", sheetNo, beanClz, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public void read(InputStream is, RowListener<Map<String, Object>> listener) throws SpreadsheetReadException {
        try (OPCPackage opcPkg = OPCPackage.open((InputStream)is);){
            XSSFReader xssfReader = new XSSFReader(opcPkg);
            XMLReader xmlReader = this.newXMLReaderInstance(opcPkg, xssfReader, listener);
            XSSFReader.SheetIterator worksheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (worksheets.hasNext()) {
                InputStream sheetInpStream = worksheets.next();
                String sheetName = worksheets.getSheetName();
                LOGGER.debug("Reading XLSX Sheet :: ", (Object)sheetName);
                xmlReader.parse(new InputSource(sheetInpStream));
                sheetInpStream.close();
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet data, to Map : %s", ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    @Override
    public void read(InputStream is, int sheetNo, RowListener<Map<String, Object>> listener) throws SpreadsheetReadException {
        try (OPCPackage opcPkg = OPCPackage.open((InputStream)is);){
            XSSFReader xssfReader = new XSSFReader(opcPkg);
            XMLReader xmlReader = this.newXMLReaderInstance(opcPkg, xssfReader, listener);
            XSSFReader.SheetIterator worksheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int i = 1;
            while (worksheets.hasNext()) {
                InputStream sheetInpStream = worksheets.next();
                String sheetName = worksheets.getSheetName();
                if (i == sheetNo) {
                    LOGGER.debug("Reading XLSX Sheet :: #{} - {}", (Object)i, (Object)sheetName);
                    xmlReader.parse(new InputSource(sheetInpStream));
                    sheetInpStream.close();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error reading sheet %d, to Map : %s", sheetNo, ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
            throw new SpreadsheetReadException(errMsg, ex);
        }
    }

    private <T> XMLReader newXMLReaderInstance(Class<T> beanClz, OPCPackage opcPkg, XSSFReader xssfReader, RowListener<T> listener) throws InvalidFormatException, IOException, SAXException, ParserConfigurationException {
        StylesTable styles = xssfReader.getStylesTable();
        ReadOnlySharedStringsTable ssTable = new ReadOnlySharedStringsTable(opcPkg);
        RowContentsHandler<T> sheetHandler = new RowContentsHandler<T>(beanClz, listener, this.headerRowIdx, this.lastRowIdx);
        XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)styles, (SharedStrings)ssTable, sheetHandler, true);
        XMLReader xmlReader = XMLHelper.newXMLReader();
        xmlReader.setContentHandler((ContentHandler)handler);
        return xmlReader;
    }

    private XMLReader newXMLReaderInstance(OPCPackage opcPkg, XSSFReader xssfReader, RowListener<Map<String, Object>> listener) throws InvalidFormatException, IOException, SAXException, ParserConfigurationException {
        StylesTable styles = xssfReader.getStylesTable();
        ReadOnlySharedStringsTable ssTable = new ReadOnlySharedStringsTable(opcPkg);
        RowContentsAsMapHandler sheetHandler = new RowContentsAsMapHandler(listener, this.headerRowIdx, this.lastRowIdx);
        XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)styles, (SharedStrings)ssTable, (XSSFSheetXMLHandler.SheetContentsHandler)sheetHandler, true);
        XMLReader xmlReader = XMLHelper.newXMLReader();
        xmlReader.setContentHandler((ContentHandler)handler);
        return xmlReader;
    }
}

