/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.writer;

import io.github.millij.poi.ss.model.Column;
import io.github.millij.poi.ss.writer.SpreadsheetWriter;
import io.github.millij.poi.util.Spreadsheet;
import io.github.millij.poi.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSpreadsheetWriter
implements SpreadsheetWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSpreadsheetWriter.class);
    protected final Workbook workbook;

    public AbstractSpreadsheetWriter(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public <T> void addSheet(Class<T> beanType, List<T> rowObjects, String inSheetName, List<String> inHeaders) {
        if (Objects.isNull(beanType)) {
            throw new IllegalArgumentException("#addSheet :: Bean Type is NULL");
        }
        String defaultSheetName = Spreadsheet.getSheetName(beanType);
        List<String> defaultHeaders = this.getColumnNames(beanType);
        String sheetName = Objects.isNull(inSheetName) ? defaultSheetName : inSheetName;
        List<String> headers = Objects.isNull(inHeaders) || inHeaders.isEmpty() ? defaultHeaders : inHeaders;
        try {
            Sheet exSheet = this.workbook.getSheet(sheetName);
            if (Objects.nonNull(exSheet)) {
                String errMsg = String.format("A Sheet with the passed name already exists : %s", sheetName);
                throw new IllegalArgumentException(errMsg);
            }
            Sheet sheet = Strings.isBlank(sheetName) ? this.workbook.createSheet() : this.workbook.createSheet(sheetName);
            LOGGER.debug("Added new Sheet[name] to the workbook : {}", (Object)sheet.getSheetName());
            Row headerRow = sheet.createRow(0);
            for (int i = 0; i < headers.size(); ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(headers.get(i));
            }
            Map<String, List<String>> rowsData = this.prepareSheetRowsData(headers, rowObjects);
            int i = 0;
            int rowNum = 1;
            while (i < rowObjects.size()) {
                Row row = sheet.createRow(rowNum);
                int cellNo = 0;
                for (String key : rowsData.keySet()) {
                    Cell cell = row.createCell(cellNo);
                    String value = rowsData.get(key).get(i);
                    cell.setCellValue(value);
                    ++cellNo;
                }
                ++i;
                ++rowNum;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error while preparing sheet with passed row objects : %s", ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
        }
    }

    @Override
    public void addSheet(List<Map<String, Object>> rowsData, String inSheetName, List<String> inHeaders) {
        if (Objects.isNull(rowsData)) {
            throw new IllegalArgumentException("#addSheet :: Rows data map is NULL");
        }
        if (Objects.isNull(inHeaders) || inHeaders.isEmpty()) {
            throw new IllegalArgumentException("#addSheet :: Headers list is NULL or EMPTY");
        }
        try {
            Sheet exSheet = this.workbook.getSheet(inSheetName);
            if (Objects.nonNull(exSheet)) {
                String errMsg = String.format("A Sheet with the passed name already exists : %s", inSheetName);
                throw new IllegalArgumentException(errMsg);
            }
            Sheet sheet = Strings.isBlank(inSheetName) ? this.workbook.createSheet() : this.workbook.createSheet(inSheetName);
            LOGGER.debug("Added new Sheet[name] to the workbook : {}", (Object)sheet.getSheetName());
            Row headerRow = sheet.createRow(0);
            for (int cellNum = 0; cellNum < inHeaders.size(); ++cellNum) {
                Cell cell = headerRow.createCell(cellNum);
                cell.setCellValue(inHeaders.get(cellNum));
            }
            int i = 0;
            int rowNum = 1;
            while (i < rowsData.size()) {
                Row row = sheet.createRow(rowNum);
                Map<String, Object> rowData = rowsData.get(i);
                if (!Objects.isNull(rowData) && !rowData.isEmpty()) {
                    for (int cellNum = 0; cellNum < inHeaders.size(); ++cellNum) {
                        String key = inHeaders.get(cellNum);
                        Object value = rowData.get(key);
                        Cell cell = row.createCell(cellNum);
                        if (!Objects.nonNull(value)) continue;
                        cell.setCellValue(String.valueOf(value));
                    }
                }
                ++i;
                ++rowNum;
            }
        }
        catch (Exception ex) {
            String errMsg = String.format("Error while preparing sheet with passed row objects : %s", ex.getMessage());
            LOGGER.error(errMsg, (Throwable)ex);
        }
    }

    @Override
    public void write(File file) throws IOException {
        if (Objects.isNull(file)) {
            throw new IllegalArgumentException("#write :: Input File object is NULL");
        }
        try (FileOutputStream outputStrem = new FileOutputStream(file);){
            this.workbook.write((OutputStream)outputStrem);
            this.workbook.close();
        }
        catch (Exception ex) {
            String errMsg = String.format("Failed to write workbook data to file : %s", file.getPath());
            LOGGER.error(errMsg);
            throw ex;
        }
    }

    private <T> Map<String, List<String>> prepareSheetRowsData(List<String> headers, List<T> rowObjects) throws Exception {
        LinkedHashMap<String, List<String>> sheetData = new LinkedHashMap<String, List<String>>();
        for (T rowObj : rowObjects) {
            Map<String, String> row = Spreadsheet.asRowDataMap(rowObj, headers);
            for (String header : headers) {
                List data = sheetData.getOrDefault(header, new ArrayList());
                String value = row.getOrDefault(header, "");
                data.add(value);
                sheetData.put(header, data);
            }
        }
        return sheetData;
    }

    private List<String> getColumnNames(Class<?> beanType) {
        Map<String, Column> propToColumnMap = Spreadsheet.getPropertyToColumnDefMap(beanType);
        ArrayList<Column> colums = new ArrayList<Column>(propToColumnMap.values());
        Collections.sort(colums);
        List<String> columnNames = colums.stream().map(Column::getName).collect(Collectors.toList());
        return columnNames;
    }
}

