/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.util;

import io.github.millij.poi.ss.model.Column;
import io.github.millij.poi.ss.model.DateTimeType;
import io.github.millij.poi.ss.model.annotations.Sheet;
import io.github.millij.poi.ss.model.annotations.SheetColumn;
import io.github.millij.poi.util.Beans;
import io.github.millij.poi.util.Strings;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spreadsheet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Spreadsheet.class);

    private Spreadsheet() {
    }

    public static String getCellColumnReference(String cellRef) {
        String cellColRef = cellRef.split("[0-9]*$")[0];
        return cellColRef;
    }

    public static String getSheetName(Class<?> beanType) {
        Sheet sheet = beanType.getAnnotation(Sheet.class);
        String sheetName = Objects.isNull(sheet) ? null : sheet.value();
        return sheetName;
    }

    public static String getSheetColumnName(SheetColumn sheetColumn, String defaultName) {
        String scValue = sheetColumn.value();
        String colName = Strings.isBlank(scValue) ? defaultName : scValue;
        return colName;
    }

    public static Column asColumn(SheetColumn sheetCol, String defaultName) {
        if (Objects.isNull(sheetCol)) {
            return new Column(defaultName);
        }
        String colName = Spreadsheet.getSheetColumnName(sheetCol, defaultName);
        Column column = new Column();
        column.setName(colName);
        column.setNullable(sheetCol.nullable());
        column.setFormat(sheetCol.format());
        column.setOrder(sheetCol.order());
        column.setDatetimeType(sheetCol.datetime());
        return column;
    }

    public static Map<String, Column> getPropertyToColumnDefMap(Class<?> beanType) {
        Method[] methods;
        String fieldName;
        Field[] fields;
        if (Objects.isNull(beanType)) {
            String errMsg = String.format("#getPropertyToColumnDefMap :: Input type is NULL", new Object[0]);
            throw new IllegalArgumentException(errMsg);
        }
        HashMap<String, Column> mappings = new HashMap<String, Column>();
        for (Field f : fields = beanType.getDeclaredFields()) {
            SheetColumn sc = f.getAnnotation(SheetColumn.class);
            if (Objects.isNull(sc)) continue;
            fieldName = f.getName();
            Column column = Spreadsheet.asColumn(sc, fieldName);
            mappings.put(fieldName, column);
        }
        for (Method m : methods = beanType.getDeclaredMethods()) {
            SheetColumn sc;
            fieldName = Beans.getFieldName(m);
            if (mappings.containsKey(fieldName) || Objects.isNull(sc = m.getAnnotation(SheetColumn.class)) && m.getName().startsWith("set")) continue;
            Column column = Spreadsheet.asColumn(sc, fieldName);
            mappings.put(fieldName, column);
        }
        return Collections.unmodifiableMap(mappings);
    }

    public static Map<String, String> asRowDataMap(Object beanObj, List<String> colHeaders) throws Exception {
        String header;
        SheetColumn sc;
        String fieldName;
        Class<?> beanType = beanObj.getClass();
        HashMap<String, String> rowDataMap = new HashMap<String, String>();
        for (Field field : beanType.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SheetColumn.class)) continue;
            fieldName = field.getName();
            sc = field.getAnnotation(SheetColumn.class);
            header = Spreadsheet.getSheetColumnName(sc, fieldName);
            if (!colHeaders.contains(header)) continue;
            rowDataMap.put(header, Beans.getFieldValueAsString(beanObj, fieldName));
        }
        for (AccessibleObject accessibleObject : beanType.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(SheetColumn.class)) continue;
            fieldName = Beans.getFieldName((Method)accessibleObject);
            sc = ((Method)accessibleObject).getAnnotation(SheetColumn.class);
            header = Spreadsheet.getSheetColumnName(sc, fieldName);
            if (!colHeaders.contains(header)) continue;
            rowDataMap.put(header, Beans.getFieldValueAsString(beanObj, fieldName));
        }
        return rowDataMap;
    }

    public static Map<String, Object> rowAsMap(Map<String, String> headerCellRefsMap, Map<String, Object> rowDataMap) {
        try {
            HashMap<String, Object> beanMap = new HashMap<String, Object>();
            for (String propColName : headerCellRefsMap.keySet()) {
                String propCellRef = headerCellRefsMap.get(propColName);
                if (Strings.isBlank(propCellRef)) continue;
                Object propValue = rowDataMap.get(propCellRef);
                beanMap.put(propColName, propValue);
            }
            return beanMap;
        }
        catch (Exception ex) {
            String errMsg = String.format("Error while creating Row Map, from - %s", rowDataMap);
            LOGGER.error(errMsg, (Throwable)ex);
            return null;
        }
    }

    public static <T> T rowAsBean(Class<T> beanClz, Map<String, Column> propColumnMap, Map<String, String> headerCellRefsMap, Map<String, Object> rowDataMap) {
        if (Objects.isNull(headerCellRefsMap) || Objects.isNull(rowDataMap)) {
            return null;
        }
        boolean isValidRowData = Spreadsheet.validateRowData(rowDataMap, headerCellRefsMap, propColumnMap);
        if (!isValidRowData) {
            LOGGER.debug("#rowAsBean :: Skipping the bean creation as the ROW data in INVALID");
            return null;
        }
        try {
            T bean = beanClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (String propName : propColumnMap.keySet()) {
                Column propColDef = propColumnMap.get(propName);
                String propColName = propColDef.getName();
                String normalizedColName = Strings.normalize(propColName);
                String propCellRef = headerCellRefsMap.get(normalizedColName);
                if (Strings.isBlank(propCellRef)) {
                    LOGGER.debug("{} :: No Cell Ref found [Prop - Col] : [{} - {}]", new Object[]{beanClz, propName, propColName});
                    continue;
                }
                Object propValue = rowDataMap.get(propCellRef);
                String dataFormat = propColDef.getFormat();
                DateTimeType datetimeType = propColDef.getDatetimeType();
                try {
                    Beans.setProperty(bean, propName, propValue, dataFormat, datetimeType);
                }
                catch (Exception ex) {
                    String exMsg = ex.getMessage();
                    String errMsg = String.format("Error setting prop - %s, val - %s : %s", propName, propValue, exMsg);
                    LOGGER.error(errMsg);
                }
            }
            return bean;
        }
        catch (Exception ex) {
            String errMsg = String.format("Error while creating bean - %s, from - %s", beanClz, rowDataMap);
            LOGGER.error(errMsg, (Throwable)ex);
            return null;
        }
    }

    private static boolean validateRowData(Map<String, Object> rowDataMap, Map<String, String> headerCellRefsMap, Map<String, Column> propColumnMap) {
        int noOfValuesFound = 0;
        for (String propName : propColumnMap.keySet()) {
            Object propValue;
            Column propColDef = propColumnMap.get(propName);
            String propColName = propColDef.getName();
            String normalizedColName = Strings.normalize(propColName);
            String propCellRef = headerCellRefsMap.containsKey(propColName) ? headerCellRefsMap.get(propColName) : headerCellRefsMap.get(normalizedColName);
            if (Strings.isBlank(propCellRef) || Objects.isNull(propValue = rowDataMap.get(propCellRef))) continue;
            ++noOfValuesFound;
        }
        boolean hasAnyValuePresent = noOfValuesFound > 0;
        return hasAnyValuePresent;
    }

    @Deprecated
    public static String normalize(String inStr) {
        return Strings.normalize(inStr);
    }
}

