/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.handler;

import io.github.millij.poi.util.Spreadsheet;
import io.github.millij.poi.util.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSheetContentsHandler
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSheetContentsHandler.class);
    private int currentRow = 0;
    private Map<String, Object> currentRowObj;

    AbstractSheetContentsHandler() {
    }

    abstract void beforeRowStart(int var1);

    abstract void afterRowEnd(int var1, Map<String, Object> var2);

    public void startRow(int rowNum) {
        this.beforeRowStart(rowNum);
        this.currentRow = rowNum;
        this.currentRowObj = new HashMap<String, Object>();
    }

    public void endRow(int rowNum) {
        this.afterRowEnd(rowNum, new HashMap<String, Object>(this.currentRowObj));
    }

    public void cell(String cellRef, String cellVal, XSSFComment comment) {
        if (Strings.isBlank(cellRef)) {
            LOGGER.error("Row[#] {} : Cell reference is empty - {}", (Object)this.currentRow, (Object)cellRef);
            return;
        }
        if (Strings.isBlank(cellVal)) {
            LOGGER.warn("Row[#] {} - Cell[ref] formatted value is empty : {} - {}", new Object[]{this.currentRow, cellRef, cellVal});
            return;
        }
        String cellColRef = Spreadsheet.getCellColumnReference(cellRef);
        LOGGER.debug("cell - Saving Column value : {} - {}", (Object)cellColRef, (Object)cellVal);
        this.currentRowObj.put(cellColRef, cellVal);
    }

    public void headerFooter(String text, boolean isHeader, String tagName) {
    }
}

