/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.handler;

import io.github.millij.poi.ss.handler.AbstractSheetContentsHandler;
import io.github.millij.poi.ss.handler.RowListener;
import io.github.millij.poi.ss.model.Column;
import io.github.millij.poi.util.Spreadsheet;
import io.github.millij.poi.util.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowContentsHandler<T>
extends AbstractSheetContentsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowContentsHandler.class);
    private final Class<T> beanClz;
    private final Map<String, Column> beanPropColumnMap;
    private final RowListener<T> listener;
    private final int headerRowNum;
    private final Map<String, String> headerCellRefsMap;
    private final int lastRowNum;

    public RowContentsHandler(Class<T> beanClz, RowListener<T> listener, int headerRowNum, int lastRowNum) {
        this.beanClz = beanClz;
        this.beanPropColumnMap = Spreadsheet.getPropertyToColumnDefMap(beanClz);
        this.listener = listener;
        this.headerRowNum = headerRowNum;
        this.headerCellRefsMap = new HashMap<String, String>();
        this.lastRowNum = lastRowNum;
    }

    @Override
    void beforeRowStart(int rowNum) {
        try {
            this.listener.beforeRow(rowNum);
        }
        catch (Exception ex) {
            String errMsg = String.format("Error calling #beforeRow callback  row - %d", rowNum);
            LOGGER.error(errMsg, (Throwable)ex);
        }
    }

    @Override
    void afterRowEnd(int rowNum, Map<String, Object> rowDataMap) {
        if (Objects.isNull(rowDataMap) || rowDataMap.isEmpty()) {
            LOGGER.debug("INVALID Row data Passed - Row #{}", (Object)rowNum);
            return;
        }
        if (rowNum < this.headerRowNum || rowNum > this.lastRowNum) {
            return;
        }
        if (rowNum == this.headerRowNum) {
            Map<String, String> headerCellRefs = this.asHeaderNameToCellRefMap(rowDataMap);
            this.headerCellRefsMap.putAll(headerCellRefs);
            return;
        }
        T rowBean = Spreadsheet.rowAsBean(this.beanClz, this.beanPropColumnMap, this.headerCellRefsMap, rowDataMap);
        if (Objects.isNull(rowBean)) {
            LOGGER.debug("Unable to construct Row data Bean object - Row #{}", (Object)rowNum);
            return;
        }
        try {
            this.listener.row(rowNum, rowBean);
        }
        catch (Exception ex) {
            String errMsg = String.format("Error calling #row callback  row - %d, bean - %s", rowNum, rowBean);
            LOGGER.error(errMsg, (Throwable)ex);
        }
    }

    private Map<String, String> asHeaderNameToCellRefMap(Map<String, Object> headerRowData) {
        if (Objects.isNull(headerRowData) || headerRowData.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headerCellRefs = new HashMap<String, String>();
        for (String colRef : headerRowData.keySet()) {
            Object header = headerRowData.get(colRef);
            String headerName = Objects.isNull(header) ? "" : String.valueOf(header);
            String normalHeaderName = Strings.normalize(headerName);
            headerCellRefs.put(normalHeaderName, colRef);
        }
        LOGGER.debug("Header Name to Cell Refs : {}", headerCellRefs);
        return headerCellRefs;
    }
}

