/*
 * Decompiled with CFR 0.152.
 */
package io.github.millij.poi.ss.reader;

import io.github.millij.poi.SpreadsheetReadException;
import io.github.millij.poi.ss.handler.RowBeanCollector;
import io.github.millij.poi.ss.reader.SpreadsheetReader;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSpreadsheetReader
implements SpreadsheetReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSpreadsheetReader.class);
    protected final int headerRowIdx;
    protected final int lastRowIdx;

    AbstractSpreadsheetReader(int headerRowIdx, int lastRowIdx) {
        this.headerRowIdx = headerRowIdx;
        this.lastRowIdx = lastRowIdx;
        String insName = this.getClass().getSimpleName();
        LOGGER.debug("Successfully instantiated {} : header #{}, lastRow #{}", new Object[]{insName, headerRowIdx, lastRowIdx});
    }

    @Override
    public <T> List<T> read(Class<T> beanClz, InputStream is) throws SpreadsheetReadException {
        RowBeanCollector beanCollector = new RowBeanCollector();
        this.read(beanClz, is, beanCollector);
        List beans = beanCollector.getBeans();
        return beans;
    }

    @Override
    public <T> List<T> read(Class<T> beanClz, InputStream is, int sheetNo) throws SpreadsheetReadException {
        RowBeanCollector beanCollector = new RowBeanCollector();
        this.read(beanClz, is, sheetNo, beanCollector);
        List beans = beanCollector.getBeans();
        return beans;
    }

    @Override
    public List<Map<String, Object>> read(InputStream is) throws SpreadsheetReadException {
        RowBeanCollector<Map<String, Object>> beanCollector = new RowBeanCollector<Map<String, Object>>();
        this.read(is, beanCollector);
        List<Map<String, Object>> beans = beanCollector.getBeans();
        return beans;
    }

    @Override
    public List<Map<String, Object>> read(InputStream is, int sheetNo) throws SpreadsheetReadException {
        RowBeanCollector<Map<String, Object>> beanCollector = new RowBeanCollector<Map<String, Object>>();
        this.read(is, sheetNo, beanCollector);
        List<Map<String, Object>> beans = beanCollector.getBeans();
        return beans;
    }
}

