/*
 * Decompiled with CFR 0.152.
 */
package io.github.miniplaceholders.api;

import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.enums.Platform;
import io.github.miniplaceholders.api.utils.Resolvers;
import io.github.miniplaceholders.connect.InternalPlatform;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MiniPlaceholders {
    static final Set<Expansion> expansions = ConcurrentHashMap.newKeySet();

    private MiniPlaceholders() {
    }

    @NotNull
    public static Platform getPlatform() {
        return switch (InternalPlatform.platform()) {
            default -> throw new IncompatibleClassChangeError();
            case InternalPlatform.PAPER -> Platform.PAPER;
            case InternalPlatform.VELOCITY -> Platform.VELOCITY;
            case InternalPlatform.KRYPTON -> Platform.KRYPTON;
            case InternalPlatform.FABRIC -> Platform.FABRIC;
            case InternalPlatform.SPONGE -> Platform.SPONGE;
        };
    }

    @NotNull
    public static TagResolver getGlobalPlaceholders() {
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion : expansions) {
            TagResolver resolver = expansion.globalPlaceholders();
            if (resolver == TagResolver.empty()) continue;
            builder.resolver(resolver);
        }
        return builder.build();
    }

    @NotNull
    public static TagResolver getAudiencePlaceholders(@NotNull Audience audience) {
        Objects.requireNonNull(audience, "audience cannot be null");
        TagResolver.Builder resolvers = TagResolver.builder();
        for (Expansion expansion : expansions) {
            TagResolver resolver = expansion.audiencePlaceholders(audience);
            Resolvers.applyIfNotEmpty(resolver, resolvers);
        }
        return resolvers.build();
    }

    @NotNull
    public static TagResolver getRelationalPlaceholders(@NotNull Audience audience, @NotNull Audience otherAudience) {
        Objects.requireNonNull(audience, "audience cannot be null");
        Objects.requireNonNull(otherAudience, "otherAudience cannot be null");
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion : expansions) {
            Resolvers.applyIfNotEmpty(expansion.relationalPlaceholders(audience, otherAudience), builder);
        }
        return builder.build();
    }

    @NotNull
    public static TagResolver getAudienceGlobalPlaceholders(@NotNull Audience audience) {
        Objects.requireNonNull(audience, "audience cannot be null");
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion : expansions) {
            Resolvers.applyIfNotEmpty(expansion.audiencePlaceholders(audience), builder);
            Resolvers.applyIfNotEmpty(expansion.globalPlaceholders(), builder);
        }
        return builder.build();
    }

    @NotNull
    public static TagResolver getRelationalGlobalPlaceholders(@NotNull Audience audience, @NotNull Audience otherAudience) {
        Objects.requireNonNull(audience, "audience cannot be null");
        Objects.requireNonNull(otherAudience, "otherAudience cannot be null");
        TagResolver.Builder builder = TagResolver.builder();
        for (Expansion expansion : expansions) {
            Resolvers.applyIfNotEmpty(expansion.audiencePlaceholders(audience), builder);
            Resolvers.applyIfNotEmpty(expansion.relationalPlaceholders(audience, otherAudience), builder);
            Resolvers.applyIfNotEmpty(expansion.globalPlaceholders(), builder);
        }
        return builder.build();
    }

    public static int getExpansionCount() {
        return expansions.size();
    }

    @Nullable
    public static Expansion getExpansionByName(@NotNull String name) {
        for (Expansion expansion : expansions) {
            if (!Objects.equals(expansion.name(), name)) continue;
            return expansion;
        }
        return null;
    }
}

