/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.android;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.android.BadgeNotification;
import com.huawei.push.android.ClickAction;
import com.huawei.push.android.LightSettings;
import com.huawei.push.message.Notification;
import com.huawei.push.model.Importance;
import com.huawei.push.model.Visibility;
import com.huawei.push.util.CollectionUtils;
import com.huawei.push.util.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class AndroidNotification {
    private static final String COLOR_PATTERN = "^#[0-9a-fA-F]{6}$";
    private static final String URL_PATTERN = "^https.*";
    private static final String VIBRATE_PATTERN = "[0-9]+|[0-9]+[sS]|[0-9]+[.][0-9]{1,9}|[0-9]+[.][0-9]{1,9}[sS]";
    @JSONField(name="title")
    private String title;
    @JSONField(name="body")
    private String body;
    @JSONField(name="icon")
    private String icon;
    @JSONField(name="color")
    private String color;
    @JSONField(name="sound")
    private String sound;
    @JSONField(name="default_sound")
    private boolean defaultSound;
    @JSONField(name="tag")
    private String tag;
    @JSONField(name="click_action")
    private ClickAction clickAction;
    @JSONField(name="body_loc_key")
    private String bodyLocKey;
    @JSONField(name="body_loc_args")
    private List<String> bodyLocArgs = new ArrayList<String>();
    @JSONField(name="title_loc_key")
    private String titleLocKey;
    @JSONField(name="title_loc_args")
    private List<String> titleLocArgs = new ArrayList<String>();
    @JSONField(name="multi_lang_key")
    private JSONObject multiLangKey;
    @JSONField(name="channel_id")
    private String channelId;
    @JSONField(name="notify_summary")
    private String notifySummary;
    @JSONField(name="image")
    private String image;
    @JSONField(name="style")
    private Integer style;
    @JSONField(name="big_title")
    private String bigTitle;
    @JSONField(name="big_body")
    private String bigBody;
    @JSONField(name="auto_clear")
    private Integer autoClear;
    @JSONField(name="notify_id")
    private Integer notifyId;
    @JSONField(name="group")
    private String group;
    @JSONField(name="badge")
    private BadgeNotification badge;
    @JSONField(name="ticker")
    private String ticker;
    @JSONField(name="auto_cancel")
    private boolean autoCancel;
    @JSONField(name="when")
    private String when;
    @JSONField(name="local_only")
    private Boolean localOnly;
    @JSONField(name="importance")
    private String importance;
    @JSONField(name="use_default_vibrate")
    private boolean useDefaultVibrate;
    @JSONField(name="use_default_light")
    private boolean useDefaultLight;
    @JSONField(name="vibrate_config")
    private List<String> vibrateConfig = new ArrayList<String>();
    @JSONField(name="visibility")
    private String visibility;
    @JSONField(name="light_settings")
    private LightSettings lightSettings;
    @JSONField(name="foreground_show")
    private boolean foregroundShow;

    private AndroidNotification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.icon = builder.icon;
        this.color = builder.color;
        this.sound = builder.sound;
        this.defaultSound = builder.defaultSound;
        this.tag = builder.tag;
        this.clickAction = builder.clickAction;
        this.bodyLocKey = builder.bodyLocKey;
        if (!CollectionUtils.isEmpty(builder.bodyLocArgs)) {
            this.bodyLocArgs.addAll(builder.bodyLocArgs);
        } else {
            this.bodyLocArgs = null;
        }
        this.titleLocKey = builder.titleLocKey;
        if (!CollectionUtils.isEmpty(builder.titleLocArgs)) {
            this.titleLocArgs.addAll(builder.titleLocArgs);
        } else {
            this.titleLocArgs = null;
        }
        this.multiLangKey = builder.multiLangkey != null ? builder.multiLangkey : null;
        this.channelId = builder.channelId;
        this.notifySummary = builder.notifySummary;
        this.image = builder.image;
        this.style = builder.style;
        this.bigTitle = builder.bigTitle;
        this.bigBody = builder.bigBody;
        this.autoClear = builder.autoClear;
        this.notifyId = builder.notifyId;
        this.group = builder.group;
        this.badge = null != builder.badge ? builder.badge : null;
        this.ticker = builder.ticker;
        this.autoCancel = builder.autoCancel;
        this.when = builder.when;
        this.importance = builder.importance;
        this.useDefaultVibrate = builder.useDefaultVibrate;
        this.useDefaultLight = builder.useDefaultLight;
        this.vibrateConfig = !CollectionUtils.isEmpty(builder.vibrateConfig) ? builder.vibrateConfig : null;
        this.visibility = builder.visibility;
        this.lightSettings = builder.lightSettings;
        this.foregroundShow = builder.foregroundShow;
    }

    public void check(Notification notification) {
        if (null != notification) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)notification.getTitle()) || StringUtils.isNotEmpty((CharSequence)this.title), "title should be set");
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)notification.getBody()) || StringUtils.isNotEmpty((CharSequence)this.body), "body should be set");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.color)) {
            ValidatorUtils.checkArgument(this.color.matches(COLOR_PATTERN), "Wrong color format, color must be in the form #RRGGBB");
        }
        if (this.clickAction != null) {
            this.clickAction.check();
        }
        if (!CollectionUtils.isEmpty(this.bodyLocArgs)) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.bodyLocKey), "bodyLocKey is required when specifying bodyLocArgs");
        }
        if (!CollectionUtils.isEmpty(this.titleLocArgs)) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.titleLocKey), "titleLocKey is required when specifying titleLocArgs");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.image)) {
            ValidatorUtils.checkArgument(this.image.matches(URL_PATTERN), "notifyIcon must start with https");
        }
        if (this.style != null) {
            boolean isTrue = this.style == 0 || this.style == 1 || this.style == 2;
            ValidatorUtils.checkArgument(isTrue, "style should be one of 0:default, 1: big text, 2: big picture");
            if (this.style == 1) {
                ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.bigTitle) && StringUtils.isNotEmpty((CharSequence)this.bigBody), "title and body are required when style = 1");
            }
        }
        if (this.autoClear != null) {
            ValidatorUtils.checkArgument(this.autoClear > 0, "auto clear should positive value");
        }
        if (this.badge != null) {
            this.badge.check();
        }
        if (this.importance != null) {
            ValidatorUtils.checkArgument(StringUtils.equals((CharSequence)this.importance, (CharSequence)Importance.LOW.getValue()) || StringUtils.equals((CharSequence)this.importance, (CharSequence)Importance.NORMAL.getValue()) || StringUtils.equals((CharSequence)this.importance, (CharSequence)Importance.HIGH.getValue()), "importance shouid be [HIGH, NORMAL, LOW]");
        }
        if (!CollectionUtils.isEmpty(this.vibrateConfig)) {
            ValidatorUtils.checkArgument(this.vibrateConfig.size() <= 10, "vibrate_config array size cannot be more than 10");
            for (String vibrateTiming : this.vibrateConfig) {
                ValidatorUtils.checkArgument(vibrateTiming.matches(VIBRATE_PATTERN), "Wrong vibrate timing format");
                long vibrateTimingValue = (long)(1000.0 * Double.valueOf(StringUtils.substringBefore((String)vibrateTiming.toLowerCase(Locale.getDefault()), (String)"s")));
                ValidatorUtils.checkArgument(vibrateTimingValue > 0L && vibrateTimingValue < 60L, "Vibrate timing duration must be greater than 0 and less than 60s");
            }
        }
        if (this.visibility != null) {
            ValidatorUtils.checkArgument(StringUtils.equals((CharSequence)this.visibility, (CharSequence)Visibility.VISIBILITY_UNSPECIFIED.getValue()) || StringUtils.equals((CharSequence)this.visibility, (CharSequence)Visibility.PRIVATE.getValue()) || StringUtils.equals((CharSequence)this.visibility, (CharSequence)Visibility.PUBLIC.getValue()) || StringUtils.equals((CharSequence)this.visibility, (CharSequence)Visibility.SECRET.getValue()), "visibility shouid be [VISIBILITY_UNSPECIFIED, PRIVATE, PUBLIC, SECRET]");
        }
        if (null != this.multiLangKey) {
            for (String key : this.multiLangKey.keySet()) {
                ValidatorUtils.checkArgument(this.multiLangKey.get((Object)key) instanceof JSONObject, "multiLangKey value should be JSONObject");
                JSONObject contentsObj = this.multiLangKey.getJSONObject(key);
                if (contentsObj == null) continue;
                ValidatorUtils.checkArgument(contentsObj.keySet().size() <= 3, "Only three lang property can carry");
            }
        }
        if (this.lightSettings != null) {
            this.lightSettings.check();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getColor() {
        return this.color;
    }

    public String getSound() {
        return this.sound;
    }

    public Boolean isDefaultSound() {
        return this.defaultSound;
    }

    public String getTag() {
        return this.tag;
    }

    public ClickAction getClickAction() {
        return this.clickAction;
    }

    public String getBodyLocKey() {
        return this.bodyLocKey;
    }

    public List<String> getBodyLocArgs() {
        return this.bodyLocArgs;
    }

    public String getTitleLocKey() {
        return this.titleLocKey;
    }

    public List<String> getTitleLocArgs() {
        return this.titleLocArgs;
    }

    public JSONObject getMultiLangKey() {
        return this.multiLangKey;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNotifySummary() {
        return this.notifySummary;
    }

    public String getImage() {
        return this.image;
    }

    public Integer getStyle() {
        return this.style;
    }

    public String getBigTitle() {
        return this.bigTitle;
    }

    public String getBigBody() {
        return this.bigBody;
    }

    public Integer getAutoClear() {
        return this.autoClear;
    }

    public Integer getNotifyId() {
        return this.notifyId;
    }

    public String getGroup() {
        return this.group;
    }

    public BadgeNotification getBadge() {
        return this.badge;
    }

    public String getTicker() {
        return this.ticker;
    }

    public String getWhen() {
        return this.when;
    }

    public String getImportance() {
        return this.importance;
    }

    public List<String> getVibrateConfig() {
        return this.vibrateConfig;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public LightSettings getLightSettings() {
        return this.lightSettings;
    }

    public boolean isAutoCancel() {
        return this.autoCancel;
    }

    public Boolean getLocalOnly() {
        return this.localOnly;
    }

    public boolean isUseDefaultVibrate() {
        return this.useDefaultVibrate;
    }

    public boolean isUseDefaultLight() {
        return this.useDefaultLight;
    }

    public boolean isForegroundShow() {
        return this.foregroundShow;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String icon;
        private String color;
        private String sound;
        private boolean defaultSound;
        private String tag;
        private ClickAction clickAction;
        private String bodyLocKey;
        private List<String> bodyLocArgs = new ArrayList<String>();
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private JSONObject multiLangkey;
        private String channelId;
        private String notifySummary;
        private String image;
        private Integer style;
        private String bigTitle;
        private String bigBody;
        private Integer autoClear;
        private Integer notifyId;
        private String group;
        private BadgeNotification badge;
        private String ticker;
        private boolean autoCancel = true;
        private String when;
        private String importance;
        private boolean useDefaultVibrate;
        private boolean useDefaultLight;
        private List<String> vibrateConfig = new ArrayList<String>();
        private String visibility;
        private LightSettings lightSettings;
        private boolean foregroundShow;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setColor(String color) {
            this.color = color;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setDefaultSound(boolean defaultSound) {
            this.defaultSound = defaultSound;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setClickAction(ClickAction clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder setBodyLocKey(String bodyLocKey) {
            this.bodyLocKey = bodyLocKey;
            return this;
        }

        public Builder addBodyLocArgs(String arg) {
            this.bodyLocArgs.add(arg);
            return this;
        }

        public Builder addAllBodyLocArgs(List<String> args) {
            this.bodyLocArgs.addAll(args);
            return this;
        }

        public Builder setTitleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public Builder addTitleLocArgs(String arg) {
            this.titleLocArgs.add(arg);
            return this;
        }

        public Builder addAllTitleLocArgs(List<String> args) {
            this.titleLocArgs.addAll(args);
            return this;
        }

        public Builder setMultiLangkey(JSONObject multiLangkey) {
            this.multiLangkey = multiLangkey;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setNotifySummary(String notifySummary) {
            this.notifySummary = notifySummary;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public Builder setStyle(Integer style) {
            this.style = style;
            return this;
        }

        public Builder setBigTitle(String bigTitle) {
            this.bigTitle = bigTitle;
            return this;
        }

        public Builder setBigBody(String bigBody) {
            this.bigBody = bigBody;
            return this;
        }

        public Builder setAutoClear(Integer autoClear) {
            this.autoClear = autoClear;
            return this;
        }

        public Builder setNotifyId(Integer notifyId) {
            this.notifyId = notifyId;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setBadge(BadgeNotification badge) {
            this.badge = badge;
            return this;
        }

        public Builder setTicker(String ticker) {
            this.ticker = ticker;
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            this.autoCancel = autoCancel;
            return this;
        }

        public Builder setWhen(String when) {
            this.when = when;
            return this;
        }

        public Builder setImportance(String importance) {
            this.importance = importance;
            return this;
        }

        public Builder setUseDefaultVibrate(boolean useDefaultVibrate) {
            this.useDefaultVibrate = useDefaultVibrate;
            return this;
        }

        public Builder setUseDefaultLight(boolean useDefaultLight) {
            this.useDefaultLight = useDefaultLight;
            return this;
        }

        public Builder addVibrateConfig(String vibrateTiming) {
            this.vibrateConfig.add(vibrateTiming);
            return this;
        }

        public Builder addAllVibrateConfig(List<String> vibrateTimings) {
            this.vibrateConfig.addAll(vibrateTimings);
            return this;
        }

        public Builder setVisibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder setLightSettings(LightSettings lightSettings) {
            this.lightSettings = lightSettings;
            return this;
        }

        public Builder setForegroundShow(boolean foregroundShow) {
            this.foregroundShow = foregroundShow;
            return this;
        }

        public AndroidNotification build() {
            return new AndroidNotification(this);
        }
    }
}

