/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.android;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.ValidatorUtils;
import org.apache.commons.lang3.StringUtils;

public class ClickAction {
    private static final String PATTERN = "^https.*";
    @JSONField(name="type")
    private Integer type;
    @JSONField(name="intent")
    private String intent;
    @JSONField(name="url")
    private String url;
    @JSONField(name="rich_resource")
    private String richResource;
    @JSONField(name="action")
    private String action;

    private ClickAction(Builder builder) {
        this.type = builder.type;
        switch (this.type) {
            case 1: {
                this.intent = builder.intent;
                this.action = builder.action;
                break;
            }
            case 2: {
                this.url = builder.url;
                break;
            }
            case 4: {
                this.richResource = builder.richResource;
            }
        }
    }

    public void check() {
        boolean isTrue = this.type == 1 || this.type == 2 || this.type == 3 || this.type == 4;
        ValidatorUtils.checkArgument(isTrue, "click type should be one of 1: customize action, 2: open url, 3: open app, 4: open rich media");
        switch (this.type) {
            case 1: {
                ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.intent) || StringUtils.isNotEmpty((CharSequence)this.action), "intent or action is required when click type=1");
                break;
            }
            case 2: {
                ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.url), "url is required when click type=2");
                ValidatorUtils.checkArgument(this.url.matches(PATTERN), "url must start with https");
                break;
            }
            case 4: {
                ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.richResource), "richResource is required when click type=4");
                ValidatorUtils.checkArgument(this.richResource.matches(PATTERN), "richResource must start with https");
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRichResource() {
        return this.richResource;
    }

    public String getAction() {
        return this.action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer type;
        private String intent;
        private String url;
        private String richResource;
        private String action;

        private Builder() {
        }

        public Builder setType(Integer type) {
            this.type = type;
            return this;
        }

        public Builder setIntent(String intent) {
            this.intent = intent;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setRichResource(String richResource) {
            this.richResource = richResource;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public ClickAction build() {
            return new ClickAction(this);
        }
    }
}

