/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.android;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.ValidatorUtils;

public class Color {
    private final float zero = -1.0E-6f;
    private final float one = 1.000001f;
    @JSONField(name="alpha")
    private Float alpha = new Float(1.0);
    @JSONField(name="red")
    private Float red = new Float(0.0);
    @JSONField(name="green")
    private Float green = new Float(0.0);
    @JSONField(name="blue")
    private Float blue = new Float(0.0);

    public Color(Builder builder) {
        this.alpha = builder.alpha;
        this.red = builder.red;
        this.green = builder.green;
        this.blue = builder.blue;
    }

    public double getAlpha() {
        return this.alpha.floatValue();
    }

    public Float getRed() {
        return this.red;
    }

    public Float getGreen() {
        return this.green;
    }

    public Float getBlue() {
        return this.blue;
    }

    public void check() {
        ValidatorUtils.checkArgument(this.alpha.floatValue() > -1.0E-6f && this.alpha.floatValue() < 1.000001f, "Alpha shoube locate between [0,1]");
        ValidatorUtils.checkArgument(this.red.floatValue() > -1.0E-6f && this.red.floatValue() < 1.000001f, "Red shoube locate between [0,1]");
        ValidatorUtils.checkArgument(this.green.floatValue() > -1.0E-6f && this.green.floatValue() < 1.000001f, "Green shoube locate between [0,1]");
        ValidatorUtils.checkArgument(this.blue.floatValue() > -1.0E-6f && this.blue.floatValue() < 1.000001f, "Blue shoube locate between [0,1]");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Float alpha = new Float(1.0);
        private Float red = new Float(0.0);
        private Float green = new Float(0.0);
        private Float blue = new Float(0.0);

        public Builder setAlpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder setRed(Float red) {
            this.red = red;
            return this;
        }

        public Builder setGreen(Float green) {
            this.green = green;
            return this;
        }

        public Builder setBlue(Float blue) {
            this.blue = blue;
            return this;
        }

        public Color build() {
            return new Color(this);
        }
    }
}

