/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.apns;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.CollectionUtils;
import com.huawei.push.util.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Alert {
    @JSONField(name="title")
    private String title;
    @JSONField(name="body")
    private String body;
    @JSONField(name="title-loc-key")
    private String titleLocKey;
    @JSONField(name="title-loc-args")
    private List<String> titleLocArgs = new ArrayList<String>();
    @JSONField(name="action-loc-key")
    private String actionLocKey;
    @JSONField(name="loc-key")
    private String locKey;
    @JSONField(name="loc-args")
    private List<String> locArgs = new ArrayList<String>();
    @JSONField(name="launch-image")
    private String launchImage;

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getTitleLocKey() {
        return this.titleLocKey;
    }

    public List<String> getTitleLocArgs() {
        return this.titleLocArgs;
    }

    public String getActionLocKey() {
        return this.actionLocKey;
    }

    public String getLocKey() {
        return this.locKey;
    }

    public List<String> getLocArgs() {
        return this.locArgs;
    }

    public String getLaunchImage() {
        return this.launchImage;
    }

    private Alert(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.titleLocKey = builder.titleLocKey;
        if (!CollectionUtils.isEmpty(builder.titleLocArgs)) {
            this.titleLocArgs.addAll(builder.titleLocArgs);
        } else {
            this.titleLocArgs = null;
        }
        this.actionLocKey = builder.actionLocKey;
        this.locKey = builder.locKey;
        if (!CollectionUtils.isEmpty(builder.locArgs)) {
            this.locArgs.addAll(builder.locArgs);
        } else {
            this.locArgs = null;
        }
        this.launchImage = builder.launchImage;
    }

    public void check() {
        if (!CollectionUtils.isEmpty(this.locArgs)) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.locKey), "locKey is required when specifying locArgs");
        }
        if (!CollectionUtils.isEmpty(this.titleLocArgs)) {
            ValidatorUtils.checkArgument(StringUtils.isNotEmpty((CharSequence)this.titleLocKey), "titleLocKey is required when specifying titleLocArgs");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String actionLocKey;
        private String locKey;
        private List<String> locArgs = new ArrayList<String>();
        private String launchImage;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setTitleLocKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public Builder setAddAllTitleLocArgs(List<String> titleLocArgs) {
            this.titleLocArgs.addAll(titleLocArgs);
            return this;
        }

        public Builder setAddTitleLocArg(String titleLocArg) {
            this.titleLocArgs.add(titleLocArg);
            return this;
        }

        public Builder setActionLocKey(String actionLocKey) {
            this.actionLocKey = actionLocKey;
            return this;
        }

        public Builder setLocKey(String locKey) {
            this.locKey = locKey;
            return this;
        }

        public Builder AddAllLocArgs(List<String> locArgs) {
            this.locArgs.addAll(locArgs);
            return this;
        }

        public Builder AddLocArg(String locArg) {
            this.locArgs.add(locArg);
            return this;
        }

        public Builder setLaunchImage(String launchImage) {
            this.launchImage = launchImage;
            return this;
        }

        public Alert build() {
            return new Alert(this);
        }
    }
}

