/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.message;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.apns.ApnsHeaders;
import com.huawei.push.apns.ApnsHmsOptions;
import com.huawei.push.apns.Aps;
import com.huawei.push.util.CollectionUtils;
import java.util.HashMap;
import java.util.Map;

public class ApnsConfig {
    @JSONField(name="hms_options")
    private ApnsHmsOptions hmsOptions;
    @JSONField(name="headers")
    private ApnsHeaders apnsHeaders;
    @JSONField(name="payload")
    private Map<String, Object> payload = new HashMap<String, Object>();

    public void check() {
        if (this.hmsOptions != null) {
            this.hmsOptions.check();
        }
        if (this.apnsHeaders != null) {
            this.apnsHeaders.check();
        }
        if (this.payload != null && this.payload.get("aps") != null) {
            Aps aps = (Aps)this.payload.get("aps");
            aps.check();
        }
    }

    public ApnsConfig(Builder builder) {
        this.hmsOptions = builder.hmsOptions;
        this.apnsHeaders = builder.apnsHeaders;
        if (!CollectionUtils.isEmpty(builder.payload) || builder.aps != null) {
            if (!CollectionUtils.isEmpty(builder.payload)) {
                this.payload.putAll(builder.payload);
            }
            if (builder.aps != null) {
                this.payload.put("aps", builder.aps);
            }
        } else {
            this.payload = null;
        }
    }

    public ApnsHmsOptions getHmsOptions() {
        return this.hmsOptions;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public ApnsHeaders getApnsHeaders() {
        return this.apnsHeaders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ApnsHmsOptions hmsOptions;
        private Map<String, Object> payload = new HashMap<String, Object>();
        private ApnsHeaders apnsHeaders;
        private Aps aps;

        public Builder setHmsOptions(ApnsHmsOptions hmsOptions) {
            this.hmsOptions = hmsOptions;
            return this;
        }

        public Builder addPayload(String key, Object value) {
            this.payload.put(key, value);
            return this;
        }

        public Builder addAllPayload(Map<String, Object> map) {
            this.payload.putAll(map);
            return this;
        }

        public Builder setApnsHeaders(ApnsHeaders apnsHeaders) {
            this.apnsHeaders = apnsHeaders;
            return this;
        }

        public Builder addPayloadAps(Aps aps) {
            this.aps = aps;
            return this;
        }

        public Builder addPayload(Aps aps) {
            this.aps = aps;
            return this;
        }

        public ApnsConfig build() {
            return new ApnsConfig(this);
        }
    }
}

