/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.message;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.ValidatorUtils;
import java.util.Locale;

public class Notification {
    @JSONField(name="title")
    private String title;
    @JSONField(name="body")
    private String body;
    @JSONField(name="image")
    private String image;

    public Notification() {
    }

    public Notification(String title, String body) {
        this.title = title;
        this.body = body;
    }

    public Notification(String title, String body, String image) {
        this.title = title;
        this.body = body;
        this.image = image;
    }

    public Notification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.image = builder.image;
    }

    public void check() {
        if (this.image != null) {
            ValidatorUtils.checkArgument(this.image.toLowerCase(Locale.getDefault()).trim().startsWith("https"), "image's url should start with HTTPS");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String image;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }
    }
}

