/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.message;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class TopicMessage {
    @JSONField(name="topic")
    private String topic;
    @JSONField(name="tokenArray")
    private List<String> tokenArray = new ArrayList<String>();
    @JSONField(name="token")
    private String token;

    public String getTopic() {
        return this.topic;
    }

    public List<String> getTokenArray() {
        return this.tokenArray;
    }

    public String getToken() {
        return this.token;
    }

    private TopicMessage(Builder builder) {
        this.topic = builder.topic;
        if (!CollectionUtils.isEmpty(builder.tokenArray)) {
            this.tokenArray.addAll(builder.tokenArray);
        } else {
            this.tokenArray = null;
        }
        this.token = builder.token;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String topic;
        private List<String> tokenArray = new ArrayList<String>();
        private String token;

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder addToken(String token) {
            this.tokenArray.add(token);
            return this;
        }

        public Builder addAllToken(List<String> tokenArray) {
            this.tokenArray.addAll(tokenArray);
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public TopicMessage build() {
            return new TopicMessage(this);
        }
    }
}

