/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.messaging;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.push.exception.HuaweiMesssagingException;
import com.huawei.push.message.Message;
import com.huawei.push.message.TopicMessage;
import com.huawei.push.messaging.HuaweiApp;
import com.huawei.push.messaging.HuaweiMessageClient;
import com.huawei.push.messaging.ImplHuaweiTrampolines;
import com.huawei.push.model.TopicOperation;
import com.huawei.push.reponse.SendResponse;
import com.huawei.push.reponse.TopicListResponse;
import com.huawei.push.reponse.TopicSendResponse;
import com.huawei.push.util.ResponceCodeProcesser;
import com.huawei.push.util.ValidatorUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HuaweiMessageClientImpl
implements HuaweiMessageClient {
    private static final String PUSH_URL = "https://push-api.cloud.huawei.com";
    private final String HcmPushUrl;
    private String hcmTopicUrl;
    private String hcmGroupUrl;
    private String hcmTokenUrl;
    private final CloseableHttpClient httpClient;

    private HuaweiMessageClientImpl(Builder builder) {
        this.HcmPushUrl = MessageFormat.format("https://push-api.cloud.huawei.com/v1/{0}/messages:send", builder.appId);
        this.hcmTopicUrl = MessageFormat.format("https://push-api.cloud.huawei.com/v1/{0}/topic:{1}", builder.appId);
        ValidatorUtils.checkArgument(builder.httpClient != null, "requestFactory must not be null");
        this.httpClient = builder.httpClient;
    }

    public String getHcmSendUrl() {
        return this.HcmPushUrl;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public SendResponse send(Message message, boolean validateOnly, String accessToken) throws HuaweiMesssagingException {
        try {
            return this.sendRequest(message, validateOnly, accessToken);
        }
        catch (IOException e) {
            throw new HuaweiMesssagingException("internal error", "Error while calling HCM backend service", e);
        }
    }

    @Override
    public SendResponse send(TopicMessage message, String operation, String accessToken) throws HuaweiMesssagingException {
        try {
            return this.sendRequest(message, operation, accessToken);
        }
        catch (IOException e) {
            throw new HuaweiMesssagingException("internal error", "Error while calling HCM backend service", e);
        }
    }

    private SendResponse sendRequest(TopicMessage message, String operation, String accessToken) throws IOException, HuaweiMesssagingException {
        this.hcmTopicUrl = MessageFormat.format(this.hcmTopicUrl, "", operation);
        HttpPost httpPost = new HttpPost(this.hcmTopicUrl);
        StringEntity entity = new StringEntity(JSON.toJSONString((Object)message), "UTF-8");
        httpPost.setHeader("Authorization", "Bearer " + accessToken);
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String rpsContent = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            JSONObject jsonObject = JSONObject.parseObject((String)rpsContent);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            String requestId = jsonObject.getString("requestId");
            if (StringUtils.equals((CharSequence)code, (CharSequence)"80000000")) {
                SendResponse sendResponse;
                if (StringUtils.equals((CharSequence)operation, (CharSequence)TopicOperation.LIST.getValue())) {
                    JSONArray topics = jsonObject.getJSONArray("topics");
                    sendResponse = TopicListResponse.fromCode(code, ResponceCodeProcesser.process(Integer.valueOf(code)), requestId, topics);
                } else {
                    Integer failureCount = jsonObject.getInteger("failureCount");
                    Integer successCount = jsonObject.getInteger("successCount");
                    JSONArray errors = jsonObject.getJSONArray("errors");
                    sendResponse = TopicSendResponse.fromCode(code, ResponceCodeProcesser.process(Integer.valueOf(code)), requestId, failureCount, successCount, errors);
                }
                return sendResponse;
            }
            String errorMsg = MessageFormat.format("error code : {0}, error message : {1}", String.valueOf(code), ResponceCodeProcesser.process(Integer.valueOf(code)));
            throw new HuaweiMesssagingException("known error", errorMsg);
        }
        HttpResponseException exception = new HttpResponseException(statusCode, rpsContent);
        throw this.createExceptionFromResponse(exception);
    }

    private SendResponse sendRequest(Message message, boolean validateOnly, String accessToken) throws IOException, HuaweiMesssagingException {
        Map<String, Object> map = this.createRequestMap(message, validateOnly);
        HttpPost httpPost = new HttpPost(this.HcmPushUrl);
        StringEntity entity = new StringEntity(JSON.toJSONString(map), "UTF-8");
        httpPost.setHeader("Authorization", "Bearer " + accessToken);
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String rpsContent = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            JSONObject jsonObject = JSONObject.parseObject((String)rpsContent);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            String requestId = jsonObject.getString("requestId");
            if (StringUtils.equals((CharSequence)code, (CharSequence)"80000000")) {
                return SendResponse.fromCode(code, ResponceCodeProcesser.process(Integer.valueOf(code)), requestId);
            }
            String errorMsg = MessageFormat.format("error code : {0}, error message : {1}", String.valueOf(code), ResponceCodeProcesser.process(Integer.valueOf(code)));
            throw new HuaweiMesssagingException("known error", errorMsg);
        }
        HttpResponseException exception = new HttpResponseException(statusCode, rpsContent);
        throw this.createExceptionFromResponse(exception);
    }

    private Map<String, Object> createRequestMap(final Message message, final boolean validateOnly) {
        return new HashMap<String, Object>(){
            {
                this.put("validate_only", validateOnly);
                this.put("message", message);
            }
        };
    }

    private HuaweiMesssagingException createExceptionFromResponse(HttpResponseException e) {
        String msg = MessageFormat.format("Unexpected HTTP response with status : {0}, body : {1}", e.getStatusCode(), e.getMessage());
        return new HuaweiMesssagingException("unknown error", msg, (Throwable)e);
    }

    static HuaweiMessageClientImpl fromApp(HuaweiApp app) {
        String appId = ImplHuaweiTrampolines.getAppId(app);
        return HuaweiMessageClientImpl.builder().setAppId(appId).setHttpClient(app.getOption().getHttpClient()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String appId;
        private CloseableHttpClient httpClient;

        private Builder() {
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setHttpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public HuaweiMessageClientImpl build() {
            return new HuaweiMessageClientImpl(this);
        }
    }
}

