/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.messaging;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.huawei.push.exception.HuaweiMesssagingException;
import com.huawei.push.message.Message;
import com.huawei.push.message.TopicMessage;
import com.huawei.push.messaging.HuaweiApp;
import com.huawei.push.messaging.HuaweiMessageClient;
import com.huawei.push.messaging.HuaweiMessageClientImpl;
import com.huawei.push.messaging.HuaweiService;
import com.huawei.push.messaging.ImplHuaweiTrampolines;
import com.huawei.push.model.TopicOperation;
import com.huawei.push.reponse.SendResponse;
import com.huawei.push.util.ValidatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiMessaging {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiMessaging.class);
    static final String INTERNAL_ERROR = "internal error";
    static final String UNKNOWN_ERROR = "unknown error";
    static final String KNOWN_ERROR = "known error";
    private final HuaweiApp app;
    private final Supplier<? extends HuaweiMessageClient> messagingClient;
    private static final String SERVICE_ID = HuaweiMessaging.class.getName();

    private HuaweiMessaging(Builder builder) {
        this.app = builder.app;
        this.messagingClient = Suppliers.memoize((Supplier)builder.messagingClient);
    }

    public static synchronized HuaweiMessaging getInstance(HuaweiApp app) {
        HuaweiMessagingService service = ImplHuaweiTrampolines.getService(app, SERVICE_ID, HuaweiMessagingService.class);
        if (service == null) {
            service = ImplHuaweiTrampolines.addService(app, new HuaweiMessagingService(app));
        }
        return (HuaweiMessaging)service.getInstance();
    }

    private static HuaweiMessaging fromApp(HuaweiApp app) {
        return HuaweiMessaging.builder().setApp(app).setMessagingClient((Supplier<? extends HuaweiMessageClient>)((Supplier)() -> HuaweiMessageClientImpl.fromApp(app))).build();
    }

    HuaweiMessageClient getMessagingClient() {
        return (HuaweiMessageClient)this.messagingClient.get();
    }

    public SendResponse sendMessage(Message message) throws HuaweiMesssagingException {
        return this.sendMessage(message, false);
    }

    public SendResponse subscribeTopic(TopicMessage topicMessage) throws HuaweiMesssagingException {
        HuaweiMessageClient messagingClient = this.getMessagingClient();
        return messagingClient.send(topicMessage, TopicOperation.SUBSCRIBE.getValue(), ImplHuaweiTrampolines.getAccessToken(this.app));
    }

    public SendResponse unsubscribeTopic(TopicMessage topicMessage) throws HuaweiMesssagingException {
        HuaweiMessageClient messagingClient = this.getMessagingClient();
        return messagingClient.send(topicMessage, TopicOperation.UNSUBSCRIBE.getValue(), ImplHuaweiTrampolines.getAccessToken(this.app));
    }

    public SendResponse listTopic(TopicMessage topicMessage) throws HuaweiMesssagingException {
        HuaweiMessageClient messagingClient = this.getMessagingClient();
        return messagingClient.send(topicMessage, TopicOperation.LIST.getValue(), ImplHuaweiTrampolines.getAccessToken(this.app));
    }

    public SendResponse sendMessage(Message message, boolean validateOnly) throws HuaweiMesssagingException {
        ValidatorUtils.checkArgument(message != null, "message must not be null");
        HuaweiMessageClient messagingClient = this.getMessagingClient();
        return messagingClient.send(message, validateOnly, ImplHuaweiTrampolines.getAccessToken(this.app));
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private HuaweiApp app;
        private Supplier<? extends HuaweiMessageClient> messagingClient;

        private Builder() {
        }

        public Builder setApp(HuaweiApp app) {
            this.app = app;
            return this;
        }

        public Builder setMessagingClient(Supplier<? extends HuaweiMessageClient> messagingClient) {
            this.messagingClient = messagingClient;
            return this;
        }

        public HuaweiMessaging build() {
            return new HuaweiMessaging(this);
        }
    }

    private static class HuaweiMessagingService
    extends HuaweiService<HuaweiMessaging> {
        HuaweiMessagingService(HuaweiApp app) {
            super(SERVICE_ID, HuaweiMessaging.fromApp(app));
        }

        @Override
        public void destroy() {
        }
    }
}

