/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.messaging;

import com.huawei.push.messaging.HuaweiCredential;
import com.huawei.push.messaging.HuaweiThreadManager;
import com.huawei.push.messaging.ThreadManager;
import com.huawei.push.util.IgnoreSSLUtils;
import com.huawei.push.util.ValidatorUtils;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiOption {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiOption.class);
    private final HuaweiCredential credential;
    private final CloseableHttpClient httpClient;
    private final ThreadManager threadManager;

    private HuaweiOption(Builder builder) {
        ValidatorUtils.checkArgument(builder.credential != null, "HuaweiOption must be initialized with setCredential()");
        this.credential = builder.credential;
        ValidatorUtils.checkArgument(builder.httpClient != null, "HuaweiOption must be initialized with a non-null httpClient");
        this.httpClient = builder.httpClient;
        ValidatorUtils.checkArgument(builder.threadManager != null, "HuaweiOption must be initialized with a non-null threadManager");
        this.threadManager = builder.threadManager;
    }

    public HuaweiCredential getCredential() {
        return this.credential;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HuaweiCredential credential;
        private CloseableHttpClient httpClient;
        private ThreadManager threadManager;

        public Builder() {
            try {
                this.httpClient = IgnoreSSLUtils.createClient();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                logger.debug("Fail to create httpClient for sending message", (Throwable)e);
            }
            this.threadManager = HuaweiThreadManager.DEFAULT_THREAD_MANAGER;
        }

        public Builder setCredential(HuaweiCredential credential) {
            this.credential = credential;
            return this;
        }

        public Builder setHttpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder setThreadManager(ThreadManager threadManager) {
            this.threadManager = threadManager;
            return this;
        }

        public HuaweiOption build() {
            return new HuaweiOption(this);
        }
    }
}

