/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.messaging;

import com.huawei.push.messaging.HuaweiApp;
import com.huawei.push.messaging.HuaweiScheduledExecutor;
import com.huawei.push.messaging.ThreadManager;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class HuaweiThreadManager {
    public static final ThreadManager DEFAULT_THREAD_MANAGER = new DefaultThreadManager();

    private static class DefaultThreadManager
    extends GlobalThreadManager {
        private DefaultThreadManager() {
        }

        @Override
        protected ExecutorService doInit() {
            ThreadFactory threadFactory = HuaweiScheduledExecutor.getThreadFactoryWithName(this.getThreadFactory(), "huawei-default-%d");
            return Executors.newCachedThreadPool(threadFactory);
        }

        @Override
        protected void doCleanup(ExecutorService executorService) {
            executorService.shutdown();
        }

        @Override
        protected ThreadFactory getThreadFactory() {
            return Executors.defaultThreadFactory();
        }
    }

    static abstract class GlobalThreadManager
    extends ThreadManager {
        private final Object lock = new Object();
        private final Set<String> apps = new HashSet<String>();
        private ExecutorService executorService;

        GlobalThreadManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ExecutorService getExecutor(HuaweiApp app) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = this.doInit();
                }
                this.apps.add(app.getOption().getCredential().getAppId());
                return this.executorService;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void releaseExecutor(HuaweiApp app, ExecutorService executor) {
            Object object = this.lock;
            synchronized (object) {
                String appId = app.getOption().getCredential().getAppId();
                if (this.apps.remove(appId) && this.apps.isEmpty()) {
                    this.doCleanup(this.executorService);
                    this.executorService = null;
                }
            }
        }

        protected abstract ExecutorService doInit();

        protected abstract void doCleanup(ExecutorService var1);
    }
}

