/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.messaging;

import com.huawei.push.messaging.HuaweiApp;
import com.huawei.push.messaging.HuaweiCredential;
import com.huawei.push.util.ValidatorUtils;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRefresher {
    private static final Logger logger = LoggerFactory.getLogger(TokenRefresher.class);
    private HuaweiApp app;
    private HuaweiCredential credential;
    private Future future;

    public TokenRefresher(HuaweiApp app) {
        ValidatorUtils.checkArgument(app != null, "app must not be null");
        this.app = app;
        this.credential = app.getOption().getCredential();
    }

    protected void scheduleNext(Runnable task, long initialDelay, long period) {
        logger.debug("Scheduling next token refresh in {} milliseconds", (Object)period);
        try {
            this.future = this.app.schedule(task, initialDelay, period);
        }
        catch (UnsupportedOperationException e) {
            logger.debug("Failed to schedule token refresh event", (Throwable)e);
        }
    }

    public void scheduleRefresh(long period) {
        this.cancelPrevious();
        this.scheduleNext(() -> this.credential.refreshToken(), period, period);
    }

    private void cancelPrevious() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    final synchronized void start() {
        logger.debug("Starting the proactive token refresher");
        String accessToken = this.credential.getAccessToken();
        if (accessToken == null || StringUtils.isEmpty((CharSequence)accessToken)) {
            this.credential.refreshToken();
        }
        long refreshDelay = this.credential.getExpireIn();
        this.scheduleRefresh(refreshDelay);
    }

    final synchronized void stop() {
        this.cancelPrevious();
        logger.debug("Stopped the proactive token refresher");
    }
}

