/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.webpush;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.CollectionUtils;
import com.huawei.push.util.ValidatorUtils;
import com.huawei.push.webpush.WebActions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WebNotification {
    private static String[] DIR_VALUE = new String[]{"auto", "ltr", "rtl"};
    @JSONField(name="title")
    private String title;
    @JSONField(name="body")
    private String body;
    @JSONField(name="icon")
    private String icon;
    @JSONField(name="image")
    private String image;
    @JSONField(name="lang")
    private String lang;
    @JSONField(name="tag")
    private String tag;
    @JSONField(name="badge")
    private String badge;
    @JSONField(name="dir")
    private String dir;
    @JSONField(name="vibrate")
    private List<Object> vibrate = new ArrayList<Object>();
    @JSONField(name="renotify")
    private boolean renotify;
    @JSONField(name="require_interaction")
    private boolean requireInteraction;
    @JSONField(name="silent")
    private boolean silent;
    @JSONField(name="timestamp")
    private Long timestamp;
    @JSONField(name="actions")
    private List<WebActions> actions = new ArrayList<WebActions>();

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getImage() {
        return this.image;
    }

    public String getLang() {
        return this.lang;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBadge() {
        return this.badge;
    }

    public String getDir() {
        return this.dir;
    }

    public List<Object> getVibrate() {
        return this.vibrate;
    }

    public boolean isRenotify() {
        return this.renotify;
    }

    public boolean isRequireInteraction() {
        return this.requireInteraction;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public List<WebActions> getActions() {
        return this.actions;
    }

    public void check() {
        if (this.dir != null) {
            ValidatorUtils.checkArgument(Arrays.stream(DIR_VALUE).anyMatch(value -> value.equals(this.dir)), "Invalid dir");
        }
        if (this.vibrate != null) {
            for (Object obj : this.vibrate) {
                ValidatorUtils.checkArgument(obj instanceof Double || obj instanceof Integer, "Invalid vibrate");
            }
        }
    }

    public WebNotification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.icon = builder.icon;
        this.image = builder.image;
        this.lang = builder.lang;
        this.tag = builder.tag;
        this.badge = builder.badge;
        this.dir = builder.dir;
        if (!CollectionUtils.isEmpty(builder.vibrate)) {
            this.vibrate.addAll(builder.vibrate);
        } else {
            this.vibrate = null;
        }
        this.renotify = builder.renotify;
        this.requireInteraction = builder.requireInteraction;
        this.silent = builder.silent;
        this.timestamp = builder.timestamp;
        if (!CollectionUtils.isEmpty(builder.actions)) {
            this.actions.addAll(builder.actions);
        } else {
            this.actions = null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String icon;
        private String image;
        private String lang;
        private String tag;
        private String badge;
        private String dir;
        private List<Object> vibrate = new ArrayList<Object>();
        private boolean renotify;
        private boolean requireInteraction;
        private boolean silent;
        private Long timestamp;
        private List<WebActions> actions = new ArrayList<WebActions>();

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public Builder setLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setBadge(String badge) {
            this.badge = badge;
            return this;
        }

        public Builder setDir(String dir) {
            this.dir = dir;
            return this;
        }

        public Builder addAllVibrate(List<Object> vibrate) {
            this.vibrate.addAll(vibrate);
            return this;
        }

        public Builder addVibrate(Object vibrate) {
            this.vibrate.add(vibrate);
            return this;
        }

        public Builder setRenotify(boolean renotify) {
            this.renotify = renotify;
            return this;
        }

        public Builder setRequireInteraction(boolean requireInteraction) {
            this.requireInteraction = requireInteraction;
            return this;
        }

        public Builder setSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder addAllActions(List<WebActions> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public Builder addAction(WebActions action) {
            this.actions.add(action);
            return this;
        }

        public WebNotification build() {
            return new WebNotification(this);
        }
    }
}

