/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.webpush;

import com.alibaba.fastjson.annotation.JSONField;
import com.huawei.push.util.ValidatorUtils;
import java.util.Arrays;

public class WebpushHeaders {
    private static String TTL_PATTERN = "[0-9]+|[0-9]+[sS]";
    private static String[] URGENCY_VALUE = new String[]{"very-low", "low", "normal", "high"};
    @JSONField(name="ttl")
    private String ttl;
    @JSONField(name="topic")
    private String topic;
    @JSONField(name="urgency")
    private String urgency;

    public String getTtl() {
        return this.ttl;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getUrgency() {
        return this.urgency;
    }

    public WebpushHeaders(Builder builder) {
        this.ttl = builder.ttl;
        this.topic = builder.topic;
        this.urgency = builder.urgency;
    }

    public void check() {
        if (this.ttl != null) {
            ValidatorUtils.checkArgument(this.ttl.matches(TTL_PATTERN), "Invalid ttl format");
        }
        if (this.urgency != null) {
            ValidatorUtils.checkArgument(Arrays.stream(URGENCY_VALUE).anyMatch(value -> value.equals(this.urgency)), "Invalid urgency");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String ttl;
        private String topic;
        private String urgency;

        public Builder setTtl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder setUrgency(String urgency) {
            this.urgency = urgency;
            return this;
        }

        public WebpushHeaders build() {
            return new WebpushHeaders(this);
        }
    }
}

