/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.ChannelInfo;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.XMStringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ChannelHelper
extends HttpBase {
    protected static final Logger logger = Logger.getLogger(ChannelHelper.class.getName());
    protected JSONObject lastResult;

    public ChannelHelper(String security) {
        super(ChannelHelper.nonNull(security));
    }

    public ChannelHelper(String security, Region region) {
        super(ChannelHelper.nonNull(security), region);
    }

    public Result addNewChannel(ChannelInfo channelInfo, int retries) throws IOException {
        Result result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to add channel " + channelInfo.toString());
            }
            boolean bl = tryAgain = (result = this.addNewChannelNoRetry(channelInfo)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result discardChannel(String channelId, int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to discard channel " + channelId);
            }
            boolean bl = tryAgain = (result = this.discardChannelNoRetry(channelId)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result getChannelList(int retries) throws IOException {
        boolean tryAgain;
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get channel list");
            }
            boolean bl = tryAgain = (result = this.getChannelListNoRetry()) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public Result addNewChannelNoRetry(ChannelInfo channelInfo) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder body = new StringBuilder();
        if (!XMStringUtils.isEmpty(channelInfo.getChannelId())) {
            ChannelHelper.addParameter(body, "channel_id", URLEncoder.encode(channelInfo.getChannelId(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(channelInfo.getChannelName())) {
            ChannelHelper.addParameter(body, "channel_name", URLEncoder.encode(channelInfo.getChannelName(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(channelInfo.getChannelDesc())) {
            ChannelHelper.addParameter(body, "channel_description", URLEncoder.encode(channelInfo.getChannelDesc(), "UTF-8"));
        }
        if (!XMStringUtils.isEmpty(channelInfo.getSoundUrl())) {
            ChannelHelper.addParameter(body, "sound_url", URLEncoder.encode(channelInfo.getSoundUrl(), "UTF-8"));
        }
        if (channelInfo.getNotifyType() != null) {
            ChannelHelper.addParameter(body, "notify_type", Integer.toString(channelInfo.getNotifyType()));
        }
        String parameterString = body.toString();
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_ADD_NEW_CHANNEL);
            conn = this.doGet(Constants.XmPushRequestPath.V1_ADD_NEW_CHANNEL, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.FINE, "IOException while get from XmPush: server " + this.remoteHost + " ip " + this.remoteIp, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = ChannelHelper.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = ChannelHelper.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        try {
            JSONObject json;
            JSONParser parser = new JSONParser();
            this.lastResult = json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            throw new IOException("Invalid response from XmPush: " + responseBody + "\n server " + this.remoteHost + " ip " + this.remoteIp);
        }
    }

    public Result discardChannelNoRetry(String channelId) throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        StringBuilder parameter = ChannelHelper.newBody("channel_id", URLEncoder.encode(channelId, "UTF-8"));
        String parameterString = parameter.toString();
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_DISCARD_CHANNEL);
            conn = this.doGet(Constants.XmPushRequestPath.V1_DISCARD_CHANNEL, parameterString);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.FINE, "IOException while get from XmPush: server " + this.remoteHost + " ip " + this.remoteIp, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = ChannelHelper.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                this.lastException = e;
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = ChannelHelper.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        try {
            JSONObject json;
            JSONParser parser = new JSONParser();
            this.lastResult = json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            throw new IOException("Invalid response from XmPush: " + responseBody + "\n server " + this.remoteHost + " ip " + this.remoteIp);
        }
    }

    public Result getChannelListNoRetry() throws IOException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_GET_CHANNEL_LIST);
            conn = this.doGet(Constants.XmPushRequestPath.V1_GET_CHANNEL_LIST, "");
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.FINE, "IOException while get from XmPush: server " + this.remoteHost + " ip " + this.remoteIp, e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = ChannelHelper.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.FINE, "Exception reading response: ", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = ChannelHelper.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: ", e);
            return null;
        }
        try {
            JSONObject json;
            JSONParser parser = new JSONParser();
            this.lastResult = json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            throw new IOException("Invalid response from XmPush: " + responseBody + "\n server " + this.remoteHost + " ip " + this.remoteIp);
        }
    }
}

