/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.logging.Level;

public class Feedback
extends HttpBase {
    public Feedback(String security) {
        super(Feedback.nonNull(security));
    }

    public Feedback(String security, Region region) {
        super(Feedback.nonNull(security), region);
    }

    public String getInvalidRegIds(int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get invalid registration ids");
            }
            boolean bl = tryAgain = (result = this.getInvalidRegIdsNoRetry()) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    public String getInvalidAliases(int retries) throws IOException {
        String result;
        boolean tryAgain;
        int attempt = 0;
        int backoff = 1000;
        do {
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to get invalid aliases");
            }
            boolean bl = tryAgain = (result = this.getInvalidAliasesNoRetry()) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    protected String getInvalidRegIdsNoRetry() throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_FEEDBACK_INVALID_REGID);
            conn = this.doGet(Constants.XmPushRequestPath.V1_FEEDBACK_INVALID_REGID, "");
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get invalid regid: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Feedback.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Feedback.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }

    protected String getInvalidAliasesNoRetry() throws InvalidRequestException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.fine("get from: " + Constants.XmPushRequestPath.V1_FEEDBACK_INVALID_ALIAS);
            conn = this.doGet(Constants.XmPushRequestPath.V1_FEEDBACK_INVALID_ALIAS, "");
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while get invalid aliases: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            this.lastException = e;
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = Feedback.getAndClose(conn.getErrorStream());
                logger.finest("Plain get error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = Feedback.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        return responseBody;
    }
}

