/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.xmpush.server;

import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.HttpBase;
import com.xiaomi.xmpush.server.InvalidRequestException;
import com.xiaomi.xmpush.server.Region;
import com.xiaomi.xmpush.server.Result;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MessageTool
extends HttpBase {
    public MessageTool(String security) {
        super(MessageTool.nonNull(security));
    }

    public MessageTool(String security, Region region) {
        super(MessageTool.nonNull(security), region);
    }

    public Result deleteTopic(String jobId, int retries) throws IOException, ParseException {
        StringBuilder body = MessageTool.newBody("id", URLEncoder.encode(jobId, "UTF-8"));
        return this.sendMessage(Constants.XmPushRequestPath.V2_DELETE_BROADCAST_MESSAGE, body, retries);
    }

    public Result deleteTopic(String jobId) throws IOException, ParseException {
        return this.deleteTopic(jobId, 1);
    }

    protected Result sendMessage(Constants.RequestPath requestPath, StringBuilder body, int retries) throws IOException, ParseException {
        int attempt = 0;
        Result result = null;
        int backoff = 1000;
        boolean tryAgain = false;
        do {
            String bodyStr;
            ++attempt;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempt #" + attempt + " to send " + body + " to url " + requestPath.getPath());
            }
            if ((bodyStr = body.toString()).charAt(0) == '&') {
                bodyStr = body.toString().substring(1);
            }
            boolean bl = tryAgain = (result = this.sendMessage(requestPath, bodyStr)) == null && attempt <= retries;
            if (!tryAgain) continue;
            int sleepTime = backoff / 2 + this.random.nextInt(backoff);
            this.sleep(sleepTime);
            if (2 * backoff >= 1024000) continue;
            backoff *= 2;
        } while (tryAgain);
        if (result == null) {
            throw this.exception(attempt);
        }
        return result;
    }

    protected Result sendMessage(Constants.RequestPath requestPath, String message) throws IOException, ParseException {
        String responseBody;
        int status;
        HttpURLConnection conn;
        try {
            logger.fine("post to: " + requestPath.getPath());
            conn = this.doPost(requestPath, message);
            status = conn.getResponseCode();
        }
        catch (IOException e) {
            this.lastException = e;
            logger.log(Level.WARNING, "IOException send message: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        if (status / 100 == 5) {
            logger.fine("XmPush service is unavailable (status " + status + "): remote server " + this.remoteHost + "(" + this.remoteIp + ")");
            return null;
        }
        if (status != 200) {
            String responseBody2;
            try {
                responseBody2 = MessageTool.getAndClose(conn.getErrorStream());
                logger.finest("Plain post error response: " + responseBody2);
            }
            catch (IOException e) {
                responseBody2 = "N/A";
                this.lastException = e;
                logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            }
            throw new InvalidRequestException(status, responseBody2);
        }
        try {
            responseBody = MessageTool.getAndClose(conn.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception reading response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(responseBody);
            return new Result.Builder().fromJson(json);
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Exception parsing response: remote server " + this.remoteHost + "(" + this.remoteIp + ")", e);
            throw new IOException("Invalid response from XmPush: " + responseBody);
        }
    }
}

