/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender;

import com.mixpush.sender.MixPushMessageConfig;
import java.util.UUID;

public class MixPushMessage {
    private String title;
    private String description;
    private String platform;
    private String payload;
    private boolean passThrough;
    private MixPushMessageConfig config = new MixPushMessageConfig();
    private String messageId;
    private boolean justOpenApp;
    private long timeToSend;
    private String oppoTaskId;
    private String vivoTaskId;

    public String getTitle() {
        return this.title;
    }

    public String getVivoTaskId() {
        return this.vivoTaskId;
    }

    public void setVivoTaskId(String vivoTaskId) {
        this.vivoTaskId = vivoTaskId;
    }

    public boolean isJustOpenApp() {
        return this.justOpenApp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPayload() {
        return this.payload;
    }

    public boolean isPassThrough() {
        return this.passThrough;
    }

    public MixPushMessageConfig getConfig() {
        return this.config;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getOppoTaskId() {
        return this.oppoTaskId;
    }

    public void setOppoTaskId(String oppoTaskId) {
        this.oppoTaskId = oppoTaskId;
    }

    public String toString() {
        return "UnifiedPushMessage{title='" + this.title + '\'' + ", content='" + this.description + '\'' + ", platform='" + this.platform + '\'' + ", payload='" + this.payload + '\'' + ", passThrough=" + this.passThrough + '}';
    }

    public long getTimeToSend() {
        return this.timeToSend;
    }

    public static class Builder {
        private MixPushMessage message = new MixPushMessage();

        public Builder payload(String value) {
            this.message.payload = value;
            return this;
        }

        public Builder title(String value) {
            this.message.title = value;
            return this;
        }

        public Builder description(String value) {
            this.message.description = value;
            return this;
        }

        public Builder passThrough(boolean passThrough) {
            this.message.passThrough = passThrough;
            return this;
        }

        public Builder justOpenApp(boolean justOpenApp) {
            this.message.justOpenApp = justOpenApp;
            return this;
        }

        public MixPushMessage build() {
            if (this.message.messageId == null) {
                this.message.messageId = UUID.randomUUID().toString();
            }
            return this.message;
        }

        public Builder config(MixPushMessageConfig config) {
            this.message.config = config;
            return this;
        }

        public Builder messageId(String messageId) {
            this.message.messageId = messageId;
            return this;
        }

        public Builder timeToSend(long milliseconds) {
            this.message.timeToSend = milliseconds;
            return this;
        }
    }
}

