/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender;

import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushResult;
import java.util.ArrayList;
import java.util.List;

public abstract class MixPushProvider {
    protected int groupSize() {
        return 1000;
    }

    public final MixPushResult sendMessage(MixPushMessage mixPushMessage, List<String> regIds) {
        List<List<String>> regIdsList = this.split(regIds, this.groupSize());
        ArrayList<MixPushResult> results = new ArrayList<MixPushResult>();
        for (List<String> item : regIdsList) {
            if (item.size() == 1) {
                results.add(this.sendMessageToSingle(mixPushMessage, item.get(0)));
                continue;
            }
            results.add(this.sendMessageToList(mixPushMessage, item));
        }
        return MixPushResult.build(results);
    }

    protected abstract MixPushResult sendMessageToSingle(MixPushMessage var1, String var2);

    protected abstract MixPushResult sendMessageToList(MixPushMessage var1, List<String> var2);

    public abstract MixPushResult broadcastMessageToAll(MixPushMessage var1);

    protected abstract String platformName();

    public abstract boolean isSupportBroadcastAll(boolean var1);

    public abstract boolean isSupportPassThrough();

    private List<List<String>> split(List<String> list, int count) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        int start = 0;
        while (start < list.size()) {
            int end = start + count;
            if (end > list.size()) {
                end = list.size();
            }
            result.add(list.subList(start, end));
            start = end + 1;
        }
        return result;
    }
}

