/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender;

import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushProvider;
import java.util.ArrayList;
import java.util.List;

public class MixPushResult {
    public static final String TEST_ENV_CAN_NOT_BROADCAST = "100";
    public static final String TEST_DATA_CAN_NOT_BROADCAST = "101";
    public static final String NOT_SUPPORT_BROADCAST = "102";
    public static final String NOT_SUPPORT = "103";
    public static final String NOT_SUPPORT_PASS_THROUGH = "104";
    private String statusCode;
    private String reason;
    private List<MixPushResult> results = new ArrayList<MixPushResult>();
    private Object extra;
    private String platformName;
    private String messageId;
    private Throwable error;
    private boolean succeed;
    private String taskId;

    private MixPushResult() {
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getReason() {
        return this.reason;
    }

    public List<MixPushResult> getResults() {
        return this.results;
    }

    public Object getExtra() {
        return this.extra;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    private static List<MixPushResult> getList(List<MixPushResult> list) {
        ArrayList<MixPushResult> newList = new ArrayList<MixPushResult>();
        for (MixPushResult it : list) {
            if (it.results.isEmpty()) {
                newList.add(it);
                continue;
            }
            newList.addAll(it.results);
            it.results = new ArrayList<MixPushResult>();
        }
        return newList;
    }

    public static MixPushResult build(List<MixPushResult> results) {
        List<MixPushResult> newList = MixPushResult.getList(results);
        MixPushResult first = newList.get(0);
        if (newList.size() == 1) {
            return first;
        }
        MixPushResult result = new MixPushResult();
        result.messageId = first.messageId;
        result.succeed = true;
        for (MixPushResult it : newList) {
            if (it.isSucceed()) continue;
            result.succeed = false;
            result.reason = it.reason;
            result.statusCode = it.statusCode;
            result.error = it.error;
            result.extra = it.extra;
            break;
        }
        result.results = results;
        return result;
    }

    public String toString() {
        return "MixPushResult{succeed='" + this.succeed + '\'' + ", platformName='" + this.platformName + '\'' + ", statusCode='" + this.statusCode + '\'' + ", reason='" + this.reason + '\'' + ", messageId='" + this.messageId + '\'' + ", taskId='" + this.taskId + '\'' + ", results=" + this.results + ", extra=" + this.extra + ", error=" + this.error + '}';
    }

    public static class Builder {
        MixPushResult result = new MixPushResult();

        public MixPushResult build() {
            return this.result;
        }

        public Builder reason(String reason) {
            this.result.reason = reason;
            return this;
        }

        public Builder statusCode(String statusCode) {
            this.result.statusCode = statusCode;
            return this;
        }

        public Builder extra(Object extra) {
            this.result.extra = extra;
            return this;
        }

        public Builder succeed(boolean success) {
            this.result.succeed = success;
            return this;
        }

        public Builder provider(MixPushProvider provider) {
            this.result.platformName = provider.platformName();
            return this;
        }

        public Builder error(Throwable throwable) {
            this.result.statusCode = "-1";
            this.result.reason = throwable.toString();
            this.result.error = throwable;
            return this;
        }

        public Builder message(MixPushMessage message) {
            this.result.messageId = message.getMessageId();
            return this;
        }

        public Builder platformName(String platformName) {
            this.result.platformName = platformName;
            return this;
        }

        public Builder taskId(String taskId) {
            this.result.taskId = taskId;
            return this;
        }
    }
}

