/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender;

import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushPlatform;
import com.mixpush.sender.MixPushProvider;
import com.mixpush.sender.MixPushResult;
import com.mixpush.sender.MixPushTarget;
import com.mixpush.sender.provider.HuaweiPushProvider;
import com.mixpush.sender.provider.MeizuPushProvider;
import com.mixpush.sender.provider.MiAPNsPushProvider;
import com.mixpush.sender.provider.MiPushProvider;
import com.mixpush.sender.provider.OppoPushProvider;
import com.mixpush.sender.provider.VivoPushProvider;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MixPushSender {
    public static final String MI = "mi";
    public static final String VIVO = "vivo";
    private String miAppSecretKey = "";
    private String packageName = "";
    private String meizuAppId;
    private String meizuAppSecretKey;
    private String huaweiAppId;
    private String huaweiAppSecret;
    private String oppoAppKey;
    private String oppoMasterSecret;
    private String vivoAppId;
    private String vivoAppKey;
    private String vivoAppSecret;
    private boolean usePassThrough = false;
    private boolean interceptTestData = true;
    private Map<String, MixPushProvider> providerMap = new HashMap<String, MixPushProvider>();
    private FileOutputStream apnsCertificate;
    private String apnsPassword;
    private boolean test;
    private String miAPNsAppSecretKey;

    private MixPushSender() {
    }

    private void register() {
        if (this.miAppSecretKey != null) {
            this.addProvider(new MiPushProvider(this.packageName, this.miAppSecretKey, this.usePassThrough, this.test));
        }
        if (this.miAPNsAppSecretKey != null) {
            this.addProvider(new MiAPNsPushProvider(this.miAPNsAppSecretKey, this.test));
        }
        if (this.meizuAppId != null) {
            this.addProvider(new MeizuPushProvider(this.meizuAppId, this.meizuAppSecretKey));
        }
        if (this.huaweiAppId != null) {
            this.addProvider(new HuaweiPushProvider(this.huaweiAppId, this.huaweiAppSecret));
        }
        if (this.oppoAppKey != null) {
            this.addProvider(new OppoPushProvider(this.oppoAppKey, this.oppoMasterSecret));
        }
        if (this.vivoAppId != null) {
            this.addProvider(new VivoPushProvider(this.vivoAppId, this.vivoAppKey, this.vivoAppSecret, this.test));
        }
    }

    private void addProvider(MixPushProvider provider) {
        this.providerMap.put(provider.platformName(), provider);
    }

    private MixPushProvider getProvider(String platformName) {
        return this.providerMap.get(platformName);
    }

    private boolean checkMaybeTest(MixPushMessage message) {
        if (this.test) {
            return true;
        }
        if (!this.interceptTestData) {
            return false;
        }
        String title = message.getTitle();
        if (title.matches("[a-zA-Z]+")) {
            return true;
        }
        if (title.matches("[0-9]+")) {
            return true;
        }
        return title.contains("test");
    }

    public MixPushResult sendMessage(MixPushMessage message, MixPushTarget target) {
        if (target.broadcastAll) {
            if (this.test) {
                return new MixPushResult.Builder().message(message).platformName(null).statusCode("100").reason("\u6d4b\u8bd5\u73af\u5883,\u65e0\u6cd5\u6267\u884c\u5168\u5c40\u63a8\u9001").build();
            }
            if (this.checkMaybeTest(message)) {
                return new MixPushResult.Builder().message(message).platformName(null).statusCode("101").reason("\u8bf7\u68c0\u67e5\u662f\u5426\u662f\u6d4b\u8bd5\u6570\u636e,\u6d4b\u8bd5\u6570\u636e\u65e0\u6cd5\u63a8\u9001\u7ed9\u8d85\u8fc710\u4eba").build();
            }
            ArrayList<MixPushResult> results = new ArrayList<MixPushResult>();
            Collection<MixPushProvider> providers = this.providerMap.values();
            for (MixPushProvider provider : providers) {
                if (message.isPassThrough() && !provider.isSupportPassThrough()) continue;
                if (provider.isSupportBroadcastAll(message.isPassThrough())) {
                    results.add(provider.broadcastMessageToAll(message));
                    continue;
                }
                results.add(new MixPushResult.Builder().message(message).platformName(provider.platformName()).statusCode("102").reason(provider.platformName() + " \u4e0d\u652f\u6301\u5168\u5c40\u63a8\u9001").succeed(true).build());
            }
            if (results.isEmpty()) {
                return new MixPushResult.Builder().message(message).statusCode("102").reason("\u4e0d\u652f\u6301\u5168\u5c40\u63a8\u9001").succeed(true).build();
            }
            return MixPushResult.build(results);
        }
        if (target.platforms.isEmpty()) {
            return new MixPushResult.Builder().reason("\u6ca1\u6709\u586b\u5199regId").build();
        }
        if (target.platforms.size() >= 10 && this.checkMaybeTest(message)) {
            return new MixPushResult.Builder().message(message).platformName(null).statusCode("101").reason("\u8bf7\u68c0\u67e5\u662f\u5426\u662f\u6d4b\u8bd5\u6570\u636e,\u6d4b\u8bd5\u6570\u636e\u65e0\u6cd5\u63a8\u9001\u7ed9\u8d85\u8fc710\u4eba").build();
        }
        HashMap map = new HashMap();
        for (MixPushPlatform item : target.platforms) {
            List<String> regIds;
            if (map.containsKey(item.platformName)) {
                regIds = (List)map.get(item.platformName);
            } else {
                regIds = new ArrayList();
                map.put(item.platformName, regIds);
            }
            regIds.add(item.regId);
        }
        ArrayList<MixPushResult> results = new ArrayList<MixPushResult>();
        Set keys = map.keySet();
        for (String platformName : keys) {
            MixPushProvider provider = this.getProvider(platformName);
            if (provider == null) {
                results.add(new MixPushResult.Builder().message(message).statusCode("103").platformName(platformName).reason("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6ce8\u518c\u5e73\u53f0 " + platformName).build());
                continue;
            }
            if (message.isPassThrough() && !provider.isSupportPassThrough()) {
                results.add(new MixPushResult.Builder().message(message).statusCode("104").platformName(platformName).reason("\u4e0d\u652f\u6301\u900f\u4f20 " + platformName).build());
                continue;
            }
            results.add(provider.sendMessage(message, (List)map.get(platformName)));
        }
        return MixPushResult.build(results);
    }

    public static class Builder {
        private MixPushSender sender = new MixPushSender();

        public Builder mi(String miAppSecretKey, boolean usePassThrough) {
            this.sender.miAppSecretKey = miAppSecretKey;
            this.sender.usePassThrough = usePassThrough;
            return this;
        }

        public Builder mi(String miAppSecretKey) {
            this.sender.miAppSecretKey = miAppSecretKey;
            this.sender.usePassThrough = false;
            return this;
        }

        public Builder oppo(String appKey, String masterSecret) {
            this.sender.oppoAppKey = appKey;
            this.sender.oppoMasterSecret = masterSecret;
            return this;
        }

        public Builder vivo(String appId, String appKey, String appSecret) {
            this.sender.vivoAppId = appId;
            this.sender.vivoAppKey = appKey;
            this.sender.vivoAppSecret = appSecret;
            return this;
        }

        public Builder huawei(String appId, String appSecret) {
            this.sender.huaweiAppId = appId;
            this.sender.huaweiAppSecret = appSecret;
            return this;
        }

        public Builder meizu(String appId, String appSecretKey) {
            this.sender.meizuAppId = appId;
            this.sender.meizuAppSecretKey = appSecretKey;
            return this;
        }

        public Builder packageName(String packageName) {
            this.sender.packageName = packageName;
            return this;
        }

        public MixPushSender build() {
            this.sender.register();
            return this.sender;
        }

        public Builder interceptTestData(boolean interceptTestData) {
            this.sender.interceptTestData = interceptTestData;
            return this;
        }

        public Builder test(boolean isTest) {
            this.sender.test = isTest;
            return this;
        }

        public Builder miAPNs(String miAPNsAppSecretKey) {
            this.sender.miAPNsAppSecretKey = miAPNsAppSecretKey;
            return this;
        }
    }
}

