/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender.provider;

import com.huawei.push.android.AndroidNotification;
import com.huawei.push.android.ClickAction;
import com.huawei.push.exception.HuaweiMesssagingException;
import com.huawei.push.message.AndroidConfig;
import com.huawei.push.message.Message;
import com.huawei.push.message.Notification;
import com.huawei.push.messaging.HuaweiApp;
import com.huawei.push.messaging.HuaweiMessaging;
import com.huawei.push.reponse.SendResponse;
import com.huawei.push.util.InitAppUtils;
import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushProvider;
import com.mixpush.sender.MixPushResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class HuaweiPushProvider
extends MixPushProvider {
    public static final String HUAWEI = "huawei";
    private final HuaweiMessaging huaweiMessaging;

    public HuaweiPushProvider(String appId, String appSecret) {
        HuaweiApp app = InitAppUtils.initializeApp((String)appId, (String)appSecret);
        this.huaweiMessaging = HuaweiMessaging.getInstance((HuaweiApp)app);
    }

    @Override
    protected MixPushResult sendMessageToSingle(MixPushMessage mixPushMessage, String regId) {
        Message.Builder builder = this.toMessage(mixPushMessage);
        builder.addToken(regId);
        try {
            SendResponse response = this.huaweiMessaging.sendMessage(builder.build());
            return this.toMixPushResult(mixPushMessage, response);
        }
        catch (HuaweiMesssagingException e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    protected MixPushResult sendMessageToList(MixPushMessage mixPushMessage, List<String> regIds) {
        Message.Builder builder = this.toMessage(mixPushMessage);
        builder.addAllToken(regIds);
        try {
            SendResponse response = this.huaweiMessaging.sendMessage(builder.build());
            return this.toMixPushResult(mixPushMessage, response);
        }
        catch (HuaweiMesssagingException e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    public MixPushResult broadcastMessageToAll(MixPushMessage mixPushMessage) {
        return new MixPushResult.Builder().provider(this).reason(this.platformName() + " \u4e0d\u652f\u6301\u5168\u5c40\u63a8\u9001").statusCode("102").build();
    }

    private Message.Builder toMessage(MixPushMessage mixPushMessage) {
        Notification notification = Notification.builder().setTitle(mixPushMessage.getTitle()).setBody(mixPushMessage.getDescription()).build();
        String url = "mixpush://com.mixpush.huawei/message?";
        if (!mixPushMessage.isJustOpenApp()) {
            try {
                url = url + "payload=" + URLEncoder.encode(mixPushMessage.getPayload(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        ClickAction clickAction = ClickAction.builder().setType(Integer.valueOf(1)).setIntent(url).build();
        AndroidNotification androidNotification = AndroidNotification.builder().setClickAction(clickAction).setChannelId(mixPushMessage.getConfig().getChannelId()).setBigTitle(mixPushMessage.getTitle()).setBigBody(mixPushMessage.getDescription()).setForegroundShow(true).build();
        AndroidConfig androidConfig = AndroidConfig.builder().setTtl(mixPushMessage.getConfig().getTimeToLive() / 1000L + "s").setNotification(androidNotification).build();
        return Message.builder().setNotification(notification).setAndroidConfig(androidConfig);
    }

    private MixPushResult toMixPushResult(MixPushMessage message, SendResponse result) {
        String errorCode = result.getCode();
        String reason = result.getMsg();
        return new MixPushResult.Builder().provider(this).message(message).statusCode(errorCode).reason(reason).extra(result).taskId(result.getRequestId()).succeed("Success".equals(result.getMsg())).build();
    }

    @Override
    protected String platformName() {
        return HUAWEI;
    }

    @Override
    public boolean isSupportBroadcastAll(boolean isPassThrough) {
        return false;
    }

    @Override
    public boolean isSupportPassThrough() {
        return false;
    }
}

