/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.meizu.push.sdk.constant.PushType;
import com.meizu.push.sdk.server.IFlymePush;
import com.meizu.push.sdk.server.constant.ResultPack;
import com.meizu.push.sdk.server.model.push.Message;
import com.meizu.push.sdk.server.model.push.PushResult;
import com.meizu.push.sdk.server.model.push.VarnishedMessage;
import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushProvider;
import com.mixpush.sender.MixPushResult;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class MeizuPushProvider
extends MixPushProvider {
    public static final String MEIZU = "meizu";
    private final IFlymePush sender;
    private String appId;

    public MeizuPushProvider(String appId, String appSecretKey) {
        this.appId = appId;
        this.sender = new IFlymePush(appSecretKey);
    }

    @Override
    protected MixPushResult sendMessageToSingle(MixPushMessage mixPushMessage, String regId) {
        return this.sendMessageToList(mixPushMessage, Collections.singletonList(regId));
    }

    @Override
    protected MixPushResult sendMessageToList(MixPushMessage mixPushMessage, List<String> regIds) {
        try {
            ResultPack result = this.sender.pushMessage(this.toMessage(mixPushMessage), regIds);
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (IOException e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    public MixPushResult broadcastMessageToAll(MixPushMessage mixPushMessage) {
        try {
            ResultPack result = this.sender.pushToApp(PushType.STATUSBAR, (Message)this.toMessage(mixPushMessage));
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (IOException e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    protected String platformName() {
        return MEIZU;
    }

    @Override
    public boolean isSupportBroadcastAll(boolean isPassThrough) {
        return !isPassThrough;
    }

    @Override
    public boolean isSupportPassThrough() {
        return false;
    }

    private MixPushResult toMixPushResult(MixPushMessage message, ResultPack<?> result) {
        String errorCode = String.valueOf(result.code());
        String reason = result.comment();
        String taskId = null;
        if (result.value() instanceof PushResult) {
            taskId = ((PushResult)result.value()).getMsgId();
        }
        return new MixPushResult.Builder().provider(this).message(message).statusCode(errorCode).reason(reason).extra(result).taskId(taskId).succeed(result.isSucceed()).build();
    }

    private VarnishedMessage toMessage(MixPushMessage mixPushMessage) {
        int hour = (int)(mixPushMessage.getConfig().getTimeToLive() / 1000L / 3600L);
        if (hour == 0) {
            hour = 1;
        }
        return new VarnishedMessage.Builder().appId(Long.valueOf(this.appId)).title(mixPushMessage.getTitle()).content(mixPushMessage.getDescription()).parameters(mixPushMessage.isJustOpenApp() ? new JSONObject() : JSON.parseObject((String)mixPushMessage.getPayload())).validTime(hour).pushTimeType(0).build();
    }
}

