/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender.provider;

import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushProvider;
import com.mixpush.sender.MixPushResult;
import com.xiaomi.push.sdk.ErrorCode;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import java.io.IOException;
import java.util.List;
import org.json.simple.parser.ParseException;

public class MiPushProvider
extends MixPushProvider {
    private final String packageName;
    private final Sender sender;
    private final boolean usePassThrough;
    private final boolean test;

    public MiPushProvider(String packageName, String appSecretKey, boolean usePassThrough, boolean test) {
        this.test = test;
        this.usePassThrough = usePassThrough;
        this.packageName = packageName;
        this.sender = new Sender(appSecretKey);
    }

    @Override
    protected MixPushResult sendMessageToSingle(MixPushMessage mixPushMessage, String regId) {
        try {
            Result result = this.sender.send(this.toMessage(mixPushMessage), regId, 3);
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    protected MixPushResult sendMessageToList(MixPushMessage mixPushMessage, List<String> regIds) {
        try {
            Result tmp = this.sender.send(this.toMessage(mixPushMessage), regIds, 3);
            return this.toMixPushResult(mixPushMessage, tmp);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    public MixPushResult broadcastMessageToAll(MixPushMessage mixPushMessage) {
        if (!this.isSupportBroadcastAll(mixPushMessage.isPassThrough())) {
            return new MixPushResult.Builder().provider(this).reason(this.platformName() + " \u4e0d\u652f\u6301\u5168\u5c40\u63a8\u9001").statusCode("102").message(mixPushMessage).build();
        }
        try {
            Result result = this.sender.broadcastAll(this.toMessage(mixPushMessage), 3);
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (IOException | ParseException e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    protected String platformName() {
        return "mi";
    }

    @Override
    public boolean isSupportBroadcastAll(boolean isPassThrough) {
        if (isPassThrough) {
            return true;
        }
        return !this.usePassThrough;
    }

    @Override
    public boolean isSupportPassThrough() {
        return true;
    }

    private MixPushResult toMixPushResult(MixPushMessage message, Result result) {
        String errorCode = String.valueOf(result.getErrorCode().getValue());
        String reason = result.getReason();
        return new MixPushResult.Builder().provider(this).message(message).statusCode(errorCode).reason(reason).extra(result).taskId(result.getMessageId()).succeed(ErrorCode.Success == result.getErrorCode()).build();
    }

    protected Message toMessage(MixPushMessage mixPushMessage) {
        Message.Builder builder = new Message.Builder().title(mixPushMessage.getTitle()).description(mixPushMessage.getDescription()).payload(mixPushMessage.isJustOpenApp() ? null : mixPushMessage.getPayload()).restrictedPackageName(this.packageName).timeToLive(mixPushMessage.getConfig().getTimeToLive()).notifyType(Integer.valueOf(1)).passThrough(mixPushMessage.isPassThrough() ? 1 : 0).timeToSend(mixPushMessage.getTimeToSend());
        if (mixPushMessage.getConfig().getMiPushChannelId() != null) {
            builder.extra("channel_id", mixPushMessage.getConfig().getMiPushChannelId());
        }
        return builder.build();
    }
}

