/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender.provider;

import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushProvider;
import com.mixpush.sender.MixPushResult;
import com.oppo.push.server.Notification;
import com.oppo.push.server.Result;
import com.oppo.push.server.Sender;
import com.oppo.push.server.Target;
import com.oppo.push.server.TargetType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OppoPushProvider
extends MixPushProvider {
    public static final String OPPO = "oppo";
    private Sender sender;

    public OppoPushProvider(String appKey, String masterSecret) {
        try {
            this.sender = new Sender(appKey, masterSecret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected int groupSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected MixPushResult sendMessageToSingle(MixPushMessage mixPushMessage, String regId) {
        return this.sendMessageToList(mixPushMessage, Collections.singletonList(regId));
    }

    @Override
    protected MixPushResult sendMessageToList(MixPushMessage mixPushMessage, List<String> regIds) {
        Notification notification = this.toMessage(mixPushMessage);
        try {
            if (mixPushMessage.getConfig().getOppoPushChannelId() == null) {
                throw new Exception("\u5fc5\u987b\u5728\u201c\u901a\u9053\u914d\u7f6e \u2192 \u65b0\u5efa\u901a\u9053\u201d\u6a21\u5757\u4e2d\u767b\u8bb0 channelId\uff0c\u518d\u5728\u53d1\u9001\u6d88\u606f\u65f6\u9009\u62e9\u901a\u9053\u53d1\u9001 https://open.oppomobile.com/wiki/doc#id=10289");
            }
            if (mixPushMessage.getOppoTaskId() == null) {
                Result result = this.sender.saveNotification(notification);
                if (result.getMessageId() == null) {
                    return this.toMixPushResult(mixPushMessage, result);
                }
                mixPushMessage.setOppoTaskId(result.getMessageId());
            }
            ArrayList<MixPushResult> results = new ArrayList<MixPushResult>();
            for (String regId : regIds) {
                Result tmp = this.sender.broadcastNotification(mixPushMessage.getOppoTaskId(), Target.build((String)regId));
                results.add(this.toMixPushResult(mixPushMessage, tmp));
            }
            return MixPushResult.build(results);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    public MixPushResult broadcastMessageToAll(MixPushMessage mixPushMessage) {
        try {
            Notification notification = this.toMessage(mixPushMessage);
            Result result = this.sender.saveNotification(notification);
            if (result.getMessageId() == null) {
                return this.toMixPushResult(mixPushMessage, result);
            }
            Target target = new Target();
            target.setTargetType(TargetType.ALL);
            result = this.sender.broadcastNotification(result.getMessageId(), target);
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    private Notification toMessage(MixPushMessage mixPushMessage) {
        Notification notification = new Notification();
        notification.setTitle(mixPushMessage.getTitle());
        notification.setContent(mixPushMessage.getDescription());
        notification.setAppMessageId(mixPushMessage.getMessageId());
        notification.setOffLineTtl(Integer.valueOf((int)(mixPushMessage.getConfig().getTimeToLive() / 1000L)));
        notification.setChannelId(mixPushMessage.getConfig().getOppoPushChannelId());
        String url = "mixpush://com.mixpush.oppo/message?";
        if (!mixPushMessage.isJustOpenApp()) {
            try {
                url = url + "payload=" + URLEncoder.encode(mixPushMessage.getPayload(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        notification.setClickActionUrl(url);
        notification.setClickActionType(Integer.valueOf(5));
        return notification;
    }

    @Override
    protected String platformName() {
        return OPPO;
    }

    @Override
    public boolean isSupportBroadcastAll(boolean isPassThrough) {
        return !isPassThrough;
    }

    @Override
    public boolean isSupportPassThrough() {
        return false;
    }

    private MixPushResult toMixPushResult(MixPushMessage message, Result result) {
        String errorCode = String.valueOf(result.getReturnCode().getCode());
        String reason = result.getReason();
        return new MixPushResult.Builder().provider(this).message(message).statusCode(errorCode).reason(reason).extra(result).taskId(message.getOppoTaskId()).succeed(result.getReturnCode().getCode() == 0).build();
    }
}

