/*
 * Decompiled with CFR 0.152.
 */
package com.mixpush.sender.provider;

import com.mixpush.sender.MixPushMessage;
import com.mixpush.sender.MixPushProvider;
import com.mixpush.sender.MixPushResult;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.notofication.TargetMessage;
import com.vivo.push.sdk.server.Sender;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class VivoPushProvider
extends MixPushProvider {
    private final boolean test;
    private Sender sender;
    private int appId;
    private String appKey;
    private long refreshTokenTime = 0L;
    final int tokenValidTime = 79200000;

    public VivoPushProvider(String appId, String appKey, String appSecret, boolean test) {
        this.appId = Integer.parseInt(appId);
        this.appKey = appKey;
        this.test = false;
        try {
            this.sender = new Sender(appSecret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshToken() throws Exception {
        if (Math.abs(System.currentTimeMillis() - this.refreshTokenTime) > 79200000L) {
            Result result = this.sender.getToken(this.appId, this.appKey);
            this.sender.setAuthToken(result.getAuthToken());
            this.refreshTokenTime = System.currentTimeMillis();
        }
    }

    @Override
    protected MixPushResult sendMessageToSingle(MixPushMessage mixPushMessage, String regId) {
        try {
            this.refreshToken();
            Result result = this.sender.sendSingle(this.toMessage(mixPushMessage).regId(regId).build());
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    protected MixPushResult sendMessageToList(MixPushMessage mixPushMessage, List<String> regIds) {
        try {
            this.refreshToken();
            if (mixPushMessage.getVivoTaskId() == null) {
                Result tmp = this.sender.saveListPayLoad(this.toMessage(mixPushMessage).build());
                if (tmp.getTaskId() == null) {
                    return this.toMixPushResult(mixPushMessage, tmp);
                }
                mixPushMessage.setVivoTaskId(tmp.getTaskId());
            }
            System.out.println(mixPushMessage.getVivoTaskId());
            TargetMessage targetMessage = new TargetMessage.Builder().taskId(mixPushMessage.getVivoTaskId()).requestId(UUID.randomUUID().toString()).regIds(new HashSet<String>(regIds)).build();
            Result result = this.sender.sendToList(targetMessage);
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    @Override
    public MixPushResult broadcastMessageToAll(MixPushMessage mixPushMessage) {
        try {
            this.refreshToken();
            Result result = this.sender.sendToAll(this.toMessage(mixPushMessage).build());
            return this.toMixPushResult(mixPushMessage, result);
        }
        catch (Exception e) {
            return new MixPushResult.Builder().provider(this).message(mixPushMessage).error(e).build();
        }
    }

    private Message.Builder toMessage(MixPushMessage mixPushMessage) {
        return new Message.Builder().notifyType(3).title(mixPushMessage.getTitle()).content(mixPushMessage.getDescription()).timeToLive((int)(mixPushMessage.getConfig().getTimeToLive() / 1000L)).skipType(3).skipContent(mixPushMessage.isJustOpenApp() ? "{}" : mixPushMessage.getPayload()).requestId(mixPushMessage.getMessageId()).classification(mixPushMessage.getConfig().isSystemMessage() ? 1 : 0);
    }

    @Override
    protected String platformName() {
        return "vivo";
    }

    @Override
    public boolean isSupportBroadcastAll(boolean isPassThrough) {
        return !isPassThrough;
    }

    @Override
    public boolean isSupportPassThrough() {
        return false;
    }

    private MixPushResult toMixPushResult(MixPushMessage message, Result result) {
        String errorCode = String.valueOf(result.getResult());
        String reason = result.getDesc();
        return new MixPushResult.Builder().provider(this).message(message).statusCode(errorCode).reason(reason).extra(result).taskId(message.getVivoTaskId()).succeed(result.getResult() == 0).build();
    }
}

