/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public abstract class Arr {
    public static void ensureSize(@NotNull ArrayList<?> arrayList, @Range(from=0L, to=0x7FFFFFFFL) int size) {
        arrayList.ensureCapacity(size);
        while (arrayList.size() < size) {
            arrayList.add(null);
        }
    }

    public static void trimToSize(@NotNull ArrayList<?> arrayList, @Range(from=0L, to=0x7FFFFFFFL) int size) {
        while (arrayList.size() > size) {
            arrayList.remove(arrayList.size() - 1);
        }
    }

    public static void resize(@NotNull ArrayList<?> arrayList, @Range(from=0L, to=0x7FFFFFFFL) int size) {
        Arr.ensureSize(arrayList, size);
        Arr.trimToSize(arrayList, size);
    }

    public static int max(int[] array) {
        int v = Integer.MIN_VALUE;
        for (int i : array) {
            if (i <= v) continue;
            v = i;
        }
        return v;
    }

    public static int min(int[] array) {
        int v = Integer.MAX_VALUE;
        for (int i : array) {
            if (i >= v) continue;
            v = i;
        }
        return v;
    }

    public static <T> T[] add(T[] array, T what) {
        T[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static <T> T[] add(T[] array, T[] other) {
        T[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static byte[] add(byte[] array, byte what) {
        byte[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static byte[] add(byte[] array, byte[] other) {
        byte[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static char[] add(char[] array, char what) {
        char[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static char[] add(char[] array, char[] other) {
        char[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static short[] add(short[] array, short what) {
        short[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static short[] add(short[] array, short[] other) {
        short[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static int[] add(int[] array, int what) {
        int[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static int[] add(int[] array, int[] other) {
        int[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static long[] add(long[] array, long what) {
        long[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static long[] add(long[] array, long[] other) {
        long[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static float[] add(float[] array, float what) {
        float[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static float[] add(float[] array, float[] other) {
        float[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static double[] add(double[] array, double what) {
        double[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static double[] add(double[] array, double[] other) {
        double[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean what) {
        boolean[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = what;
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean[] other) {
        boolean[] newArray = Arrays.copyOf(array, array.length + other.length);
        System.arraycopy(other, 0, newArray, array.length, other.length);
        return newArray;
    }

    public static <T> boolean containsReference(T[] arr, T elem) {
        for (T entry : arr) {
            if (entry != elem) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] arr, char elem) {
        for (char entry : arr) {
            if (entry != elem) continue;
            return true;
        }
        return false;
    }
}

