/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class IO {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void write(byte[] data, OutputStream outputStream) {
        try {
            outputStream.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write all bytes.", e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void write(byte[] data, File file) {
        try {
            IO.write(data, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to write data to file: File not found: [" + file.getPath() + "].", e);
        }
    }

    public static void write(String string, File file, Charset charset) {
        IO.write(string.getBytes(charset), file);
    }

    public static void write(String string, File file) {
        IO.write(string.getBytes(), file);
    }

    public static byte[] readAllBytes(File file) {
        try {
            return IO.readAllBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to read from file: File is not found: [" + file.getPath() + "].", e);
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int bytesReadCount;
        byte[] buffer = new byte[bufferSize];
        while ((bytesReadCount = inputStream.read(buffer, 0, buffer.length)) != -1) {
            outputStream.write(buffer, 0, bytesReadCount);
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        IO.copyStream(inputStream, outputStream, 4096);
    }

    /*
     * Exception decompiling
     */
    public static byte[] readAllBytes(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readAllToString(File targetFile) {
        return new String(IO.readAllBytes(targetFile), Charset.defaultCharset());
    }

    public static void cleanDirectory(File directory) {
        File[] children = directory.listFiles();
        if (children == null) {
            return;
        }
        for (File entry : children) {
            if (entry.isDirectory()) {
                IO.cleanDirectory(entry);
            }
            if (entry.delete()) continue;
            throw new RuntimeException("Failed to delete file: [" + entry.getAbsolutePath() + "].");
        }
    }

    public static void cleanDirectory(String directory) {
        IO.cleanDirectory(new File(directory));
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            IO.cleanDirectory(file);
        }
        if (!file.delete()) {
            throw new RuntimeException("Failed to delete file: [" + file.getAbsolutePath() + "].");
        }
    }

    public static File mkdirs(File destination) {
        if (!destination.mkdirs() && !destination.exists()) {
            throw new RuntimeException("Failed to create directories: [" + destination.getAbsolutePath() + "].");
        }
        return destination;
    }

    public static File mkdirs(String destination) {
        return IO.mkdirs(new File(destination));
    }
}

