/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.mjaron.etudes.container.ListRandomAccess;
import pl.mjaron.etudes.container.VectorRandomAccess;

public interface IRandomAccess<T> {
    @Contract(pure=true)
    public int size();

    @Contract(pure=true)
    @Nullable
    public T get(int var1);

    @NotNull
    public static <U> IRandomAccess<U> from(@NotNull List<U> list) {
        return new ListRandomAccess<U>(list);
    }

    @NotNull
    public static <U> IRandomAccess<U> from(@NotNull Vector<U> vector) {
        return new VectorRandomAccess<U>(vector);
    }
}

