/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pl.mjaron.etudes.ICurrIterator;
import pl.mjaron.etudes.IRandomAccess;
import pl.mjaron.etudes.iterator.CachingRandomIteratorWrapper;
import pl.mjaron.etudes.iterator.RandomAccessIteratorWrapper;

public interface IRandomIterator<T>
extends ICurrIterator<T> {
    public static final int FLOOR = -1;

    default public boolean isFloorPosition() {
        return this.getPosition() == -1;
    }

    default public void setFloorPosition() {
        this.setPosition(-1);
    }

    @Contract(pure=true)
    public int getPosition();

    public void setPosition(int var1);

    public void increment(int var1);

    public void increment();

    public void decrement(int var1);

    public void decrement();

    @NotNull
    public static <U> IRandomIterator<U> from(Iterator<U> it) {
        return new CachingRandomIteratorWrapper<U>(it);
    }

    @NotNull
    public static <U> IRandomIterator<U> from(List<U> list) {
        if (list instanceof RandomAccess) {
            return new RandomAccessIteratorWrapper<U>(IRandomAccess.from(list));
        }
        return new CachingRandomIteratorWrapper<U>(list.iterator());
    }

    @NotNull
    public static <U> IRandomIterator<U> from(Vector<U> vector) {
        return new RandomAccessIteratorWrapper<U>(IRandomAccess.from(vector));
    }

    @NotNull
    public static <U> IRandomIterator<U> from(Iterable<U> it) {
        return new CachingRandomIteratorWrapper<U>(it.iterator());
    }
}

