/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public interface ISystemOutAcquire
extends AutoCloseable {
    public PrintStream getOriginalOut();

    public PrintStream getNewOut();

    @Override
    public void close();

    public static ToPrintStream acquire(PrintStream newOut) {
        return new ToPrintStream(newOut);
    }

    public static ToByteArray acquire(ByteArrayOutputStream byteArrayOutputStream) {
        return new ToByteArray(byteArrayOutputStream);
    }

    public static ToByteArray acquire() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return ISystemOutAcquire.acquire(byteArrayOutputStream);
    }

    public static String acquire(Runnable runnable) {
        try (ToByteArray acquire = ISystemOutAcquire.acquire();){
            runnable.run();
            String string = ((Object)acquire).toString();
            return string;
        }
    }

    public static class ToByteArray
    extends ToPrintStream {
        private final ByteArrayOutputStream byteArrayOutputStream;

        public ToByteArray(ByteArrayOutputStream byteArrayOutputStream) {
            super(new PrintStream(byteArrayOutputStream));
            this.byteArrayOutputStream = byteArrayOutputStream;
        }

        public String toString() {
            return this.byteArrayOutputStream.toString();
        }

        public ByteArrayOutputStream getByteArrayOutputStream() {
            return this.byteArrayOutputStream;
        }
    }

    public static class ToPrintStream
    implements ISystemOutAcquire {
        private final PrintStream originalOut = System.out;
        private final PrintStream newOut;

        public ToPrintStream(PrintStream newOut) {
            this.newOut = newOut;
            this.originalOut.flush();
            newOut.flush();
            System.setOut(newOut);
        }

        @Override
        public void close() {
            this.originalOut.flush();
            this.newOut.flush();
            System.setOut(this.originalOut);
        }

        @Override
        public PrintStream getOriginalOut() {
            return this.originalOut;
        }

        @Override
        public PrintStream getNewOut() {
            return this.newOut;
        }
    }
}

