/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import pl.mjaron.etudes.Str;
import pl.mjaron.etudes.Table;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.ITableWriter;

public abstract class Obj {
    public static <T> Field[] getFields(Class<T> tClass) {
        return tClass.getDeclaredFields();
    }

    public static List<String> getFieldNames(Field[] fields) {
        ArrayList<String> names = new ArrayList<String>(fields.length);
        for (Field entry : fields) {
            names.add(entry.getName());
        }
        return names;
    }

    public static <T> List<String> getFieldNames(Class<T> tClass) {
        Field[] fields = Obj.getFields(tClass);
        return Obj.getFieldNames(fields);
    }

    public static <T> void visitFieldValues(T what, Class<T> tClass, Field[] fields, IFieldVisitor visitor) {
        for (Field field : fields) {
            try {
                Object fieldValue = field.get(what);
                visitor.visit(field.getName(), fieldValue);
            }
            catch (IllegalAccessException fieldValue) {
                Method getter;
                block10: {
                    String fieldNameCapitalized = Str.capitalize(field.getName());
                    try {
                        getter = tClass.getMethod("get" + fieldNameCapitalized, new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                            try {
                                getter = tClass.getMethod("is" + fieldNameCapitalized, new Class[0]);
                                break block10;
                            }
                            catch (NoSuchMethodException e2) {
                                throw new RuntimeException("Cannot obtain value of field: [" + field.getName() + "], of type: [" + field.getType() + "]: Field is not public and there is no get" + fieldNameCapitalized + "() + nor is" + fieldNameCapitalized + "() method accessible.", e2);
                            }
                        }
                        throw new RuntimeException("Cannot obtain value of field: [" + field.getName() + "], of type: [" + field.getType() + "]: Field is not public and there is no get" + fieldNameCapitalized + "() method accessible.", e1);
                    }
                }
                try {
                    Object getterResult = getter.invoke(what, new Object[0]);
                    visitor.visit(field.getName(), getterResult);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Cannot obtain value of field: [" + field.getName() + "], of type: [" + field.getType() + "]: invocation of getter has failed.", e);
                }
            }
        }
    }

    public static <T> Map<String, Object> getFieldValues(T what) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = what.getClass();
        Field[] fields = clazz.getDeclaredFields();
        Obj.visitFieldValues(what, clazz, fields, new IFieldVisitor(){

            @Override
            public void visit(String name, Object value) {
                map.put(name, value);
            }
        });
        return map;
    }

    public static <T> Map<String, String> getFieldValuesAsStrings(T what) {
        Map<String, Object> fieldObjects = Obj.getFieldValues(what);
        HashMap<String, String> fieldStrings = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : fieldObjects.entrySet()) {
            fieldStrings.put(entry.getKey(), entry.getValue().toString());
        }
        return fieldStrings;
    }

    @Contract(pure=true)
    public static <T> String asTable(Iterable<T> iterable, Class<T> tClass) {
        return Table.render(iterable, tClass).runToString();
    }

    @Contract(pure=true)
    public static <SourceT extends ITableSource, WriterT extends ITableWriter> String asTable(SourceT source, WriterT writer) {
        return Table.render(source).withWriter(writer).runToString();
    }

    public static interface IFieldVisitor {
        public void visit(String var1, Object var2);
    }
}

