/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import pl.mjaron.etudes.Str;

public abstract class Path {
    public static final String COMMON_SEPARATORS = "/\\";
    public static final char EXTENSION_CHAR = '.';

    public static int lastSeparatorPos(String path, String separators) {
        return Str.lastIndexAnyOf(path, separators);
    }

    public static int lastSeparatorPos(String path, char separator) {
        return Str.lastIndexOf(path, separator);
    }

    public static int lastExtensionPos(String path) {
        return path.lastIndexOf(46);
    }

    public static int extensionPos(String path, String separators) {
        int lastExtension = Path.lastExtensionPos(path);
        if (lastExtension == -1) {
            return -1;
        }
        int lastSeparator = Path.lastSeparatorPos(path, separators);
        if (lastSeparator > lastExtension) {
            return -1;
        }
        return lastExtension;
    }

    public static int extensionPos(String path, char separator) {
        int lastExtension = Path.lastExtensionPos(path);
        if (lastExtension == -1) {
            return -1;
        }
        int lastSeparator = Path.lastSeparatorPos(path, separator);
        if (lastSeparator > lastExtension) {
            return -1;
        }
        return lastExtension;
    }

    public static String extension(String path, String separators) {
        int dot = Path.extensionPos(path, separators);
        if (dot < 0) {
            return "";
        }
        return path.substring(dot + 1);
    }

    public static String extension(String path, char separator) {
        int dot = Path.extensionPos(path, separator);
        if (dot < 0) {
            return "";
        }
        return path.substring(dot + 1);
    }

    public static String extension(String path) {
        return Path.extension(path, COMMON_SEPARATORS);
    }

    public static String noExtension(String path, String separators) {
        int dot = Path.extensionPos(path, separators);
        if (dot < 0) {
            return path;
        }
        return path.substring(0, dot);
    }

    public static String noExtension(String path, char separator) {
        int dot = Path.extensionPos(path, separator);
        if (dot < 0) {
            return path;
        }
        return path.substring(0, dot);
    }

    public static String noExtension(String path) {
        return Path.noExtension(path, COMMON_SEPARATORS);
    }

    public static String filename(String path, char separator) {
        int separatorIdx = path.lastIndexOf(separator);
        if (separatorIdx <= 0) {
            return path;
        }
        if (separatorIdx + 1 == path.length()) {
            return "";
        }
        return path.substring(separatorIdx + 1);
    }

    public static String filename(String path, String separators) {
        int separatorIdx = Str.lastIndexAnyOf(path, separators);
        if (separatorIdx <= 0) {
            return path;
        }
        if (separatorIdx + 1 == path.length()) {
            return "";
        }
        return path.substring(separatorIdx + 1);
    }

    public static String filename(String path) {
        return Path.filename(path, COMMON_SEPARATORS);
    }

    public static String noEndSeparator(String path, String separators) {
        if (path.isEmpty()) {
            return path;
        }
        if (separators.indexOf(path.charAt(path.length() - 1)) < 0) {
            return path;
        }
        return path.substring(0, path.length() - 1);
    }

    public static String noEndSeparator(String path, char separator) {
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(path.length() - 1) != separator) {
            return path;
        }
        return path.substring(0, path.length() - 1);
    }

    public static String noEndSeparator(String path) {
        return Path.noEndSeparator(path, COMMON_SEPARATORS);
    }

    public static String parent(String path, String separators) {
        int separatorIdx = Str.lastIndexAnyOf(path, separators);
        if (separatorIdx <= 0) {
            return "";
        }
        return path.substring(0, separatorIdx);
    }

    public static String parent(String path, char separator) {
        int separatorIdx = path.lastIndexOf(separator);
        if (separatorIdx <= 0) {
            return "";
        }
        return path.substring(0, separatorIdx);
    }

    public static String parent(String path) {
        return Path.parent(path, COMMON_SEPARATORS);
    }
}

