/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import pl.mjaron.etudes.Ch;
import pl.mjaron.etudes.IPureAppendable;

public abstract class Str {
    public static final int STR_HEX_DEFAULT_BYTES_PER_LINE = 64;
    public static final String STR_HEX_DEFAULT_BYTE_SEPARATOR = " ";
    public static final String CRLF = "\r\n";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final char CR_H = '\r';
    public static final char LF_H = '\n';

    public static boolean isEmpty(String what) {
        return what == null || what.isEmpty();
    }

    public static boolean notEmpty(String what) {
        return !Str.isEmpty(what);
    }

    public static String ifEmpty(String what, String alternative) {
        return Str.isEmpty(what) ? alternative : what;
    }

    public static String orEmpty(String what) {
        if (what == null) {
            return "";
        }
        return what;
    }

    public static String orEmpty(Object what) {
        if (what == null) {
            return "";
        }
        return what.toString();
    }

    public static int charsCount(String what, char ch) {
        int count = 0;
        int len = what.length();
        for (int i = 0; i < len; ++i) {
            if (what.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static boolean contains(String str, String what) {
        return str.contains(what);
    }

    public static boolean contains(String str, char what) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != what) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String str, char ... what) {
        for (char ch : what) {
            if (!Str.contains(str, ch)) continue;
            return true;
        }
        return false;
    }

    public static String capitalize(String what, Locale locale) {
        if (Str.isEmpty(what)) {
            return what;
        }
        if (!Character.isLowerCase(what.charAt(0))) {
            return what;
        }
        return what.substring(0, 1).toUpperCase(locale) + what.substring(1);
    }

    public static String capitalize(String what) {
        return Str.capitalize(what, Locale.ROOT);
    }

    public static void padLeft(String what, int size, char ch, Appendable out) {
        try {
            for (int missing = size - what.length(); missing > 0; --missing) {
                out.append(ch);
            }
            out.append(what);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append String.", e);
        }
    }

    public static String padLeft(String what, int size, char ch) {
        StringBuilder out = new StringBuilder();
        Str.padLeft(what, size, ch, out);
        return out.toString();
    }

    public static String padLeft(String what, int size) {
        return Str.padLeft(what, size, ' ');
    }

    public static void padRight(String what, int size, char ch, Appendable out) {
        try {
            out.append(what);
            for (int missing = size - what.length(); missing > 0; --missing) {
                out.append(ch);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append String.", e);
        }
    }

    public static String padRight(String what, int size, char ch) {
        StringBuilder out = new StringBuilder();
        Str.padRight(what, size, ch, out);
        return out.toString();
    }

    public static String padRight(String what, int size) {
        return Str.padRight(what, size, ' ');
    }

    public static void pad(Appendable out, int size, char ch) {
        try {
            while (size > 0) {
                out.append(ch);
                --size;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append character " + size + " times.", e);
        }
    }

    public static void padCenter(String what, int size, char ch, Appendable out) {
        try {
            int toPad = size - what.length();
            if (toPad <= 0) {
                out.append(what);
                return;
            }
            if (toPad == 1) {
                out.append(what);
                out.append(ch);
                return;
            }
            int toPadRight = toPad / 2 + ((toPad & 1) == 1 ? 1 : 0);
            int toPadLeft = toPad / 2;
            Str.pad(out, toPadLeft, ch);
            out.append(what);
            Str.pad(out, toPadRight, ch);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to pad center the String.", e);
        }
    }

    public static String padCenter(String what, int size, char ch) {
        StringBuilder out = new StringBuilder();
        Str.padCenter(what, size, ch, out);
        return out.toString();
    }

    public static String padCenter(String what, int size) {
        return Str.padCenter(what, size, ' ');
    }

    public static int lastIndexAnyOf(String what, String chars) {
        for (int idx = what.length() - 1; idx >= 0; --idx) {
            for (int ch = 0; ch < chars.length(); ++ch) {
                if (what.charAt(idx) != chars.charAt(ch)) continue;
                return idx;
            }
        }
        return -1;
    }

    public static int lastIndexOf(String what, char ch) {
        return what.lastIndexOf(ch);
    }

    public static int isGraphCount(String str) {
        int hCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!Ch.isGraph(str.charAt(i))) continue;
            ++hCount;
        }
        return hCount;
    }

    public static void hex(StringBuilder str, byte[] arr, int arrBegin, int arrEnd, int bytesPerLine, String byteSeparator) {
        int i = arrBegin;
        int index = 0;
        while (i < arrEnd) {
            byte b = arr[i];
            impl.hexEntryImpl(str, b, index, bytesPerLine, byteSeparator);
            ++i;
            ++index;
        }
    }

    public static void hex(StringBuilder str, int[] arr, int arrBegin, int arrEnd, int bytesPerLine, String byteSeparator) {
        int i = arrBegin;
        int index = 0;
        while (i < arrEnd) {
            byte b = (byte)arr[i];
            impl.hexEntryImpl(str, b, index, bytesPerLine, byteSeparator);
            ++i;
            ++index;
        }
    }

    public static String hex(byte[] arr, int arrBegin, int arrEnd, int bytesPerLine, String byteSeparator) {
        StringBuilder str = impl.hexPrepareStringBuilder(arrBegin, arrEnd, bytesPerLine, byteSeparator);
        Str.hex(str, arr, arrBegin, arrEnd, bytesPerLine, byteSeparator);
        return str.toString();
    }

    public static String hex(int[] arr, int arrBegin, int arrEnd, int bytesPerLine, String byteSeparator) {
        StringBuilder str = impl.hexPrepareStringBuilder(arrBegin, arrEnd, bytesPerLine, byteSeparator);
        Str.hex(str, arr, arrBegin, arrEnd, bytesPerLine, byteSeparator);
        return str.toString();
    }

    public static String hex(int[] arr, int arrBegin, int arrEnd) {
        return Str.hex(arr, arrBegin, arrEnd, 64, STR_HEX_DEFAULT_BYTE_SEPARATOR);
    }

    public static String hex(byte[] arr, int arrBegin, int arrEnd) {
        return Str.hex(arr, arrBegin, arrEnd, 64, STR_HEX_DEFAULT_BYTE_SEPARATOR);
    }

    public static String hex(byte[] arr) {
        return Str.hex(arr, 0, arr.length, 64, STR_HEX_DEFAULT_BYTE_SEPARATOR);
    }

    public static String hex(int[] arr) {
        return Str.hex(arr, 0, arr.length, 64, STR_HEX_DEFAULT_BYTE_SEPARATOR);
    }

    public static byte[] hex(String str) {
        int hCount = Str.isGraphCount(str) / 2;
        byte[] arr = new byte[hCount];
        boolean isHighNibble = true;
        int b = 0;
        int a = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!Ch.isGraph(str.charAt(i))) continue;
            if (isHighNibble) {
                b = (byte)(Ch.toHexValue(str.charAt(i)) << 4);
                isHighNibble = false;
                continue;
            }
            arr[a] = b = (int)((byte)(b | Ch.toHexValue(str.charAt(i))));
            ++a;
            isHighNibble = true;
        }
        return arr;
    }

    public static <T> void join(Iterable<T> what, String separator, IPureAppendable out) {
        boolean isFirst = true;
        for (T entry : what) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.append(separator);
            }
            out.append(what.toString());
        }
    }

    public static <T> void join(Iterable<T> what, String separator, StringBuilder out) {
        Str.join(what, separator, IPureAppendable.from(out));
    }

    public static <T> void join(Iterable<T> what, String separator, PrintStream out) {
        Str.join(what, separator, IPureAppendable.from(out));
    }

    public static <T> String join(Iterable<T> what, String separator) {
        StringBuilder out = new StringBuilder();
        Str.join(what, separator, out);
        return out.toString();
    }

    public static abstract class impl {
        public static void hexEntryImpl(StringBuilder str, byte b, int index, int bytesPerLine, String byteSeparator) {
            if (index != 0) {
                if (bytesPerLine > 0 && index % bytesPerLine == 0) {
                    str.append('\n');
                } else {
                    str.append(byteSeparator);
                }
            }
            str.append(String.format("%02X", b));
        }

        public static StringBuilder hexPrepareStringBuilder(int arrBegin, int arrEnd, int bytesPerLine, String byteSeparator) {
            int bytesCount = arrEnd - arrBegin;
            int byteSize = 2 + byteSeparator.length();
            int linesCount = bytesPerLine <= 0 ? 1 : bytesCount / bytesPerLine;
            return new StringBuilder(bytesCount * byteSize + linesCount);
        }
    }
}

