/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes;

import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import pl.mjaron.etudes.table.BeanTableSource;
import pl.mjaron.etudes.table.ITableSource;
import pl.mjaron.etudes.table.RenderContext;

public abstract class Table {
    @Contract(pure=true)
    public static RenderContext render(ITableSource source) {
        RenderContext context = RenderContext.make();
        context.setSource(source);
        return context;
    }

    @Contract(pure=true)
    public static <T> RenderContext render(Iterable<T> iterable, Class<T> tClass) {
        return Table.render(new BeanTableSource<T>(iterable, tClass));
    }

    @Contract(pure=true)
    public static <T> RenderContext render(T[] array, Class<T> tClass) {
        return Table.render(Arrays.asList(array), tClass);
    }
}

