/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.container;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import pl.mjaron.etudes.IPureAppendable;

public class OutputStreamPureAppendable
implements IPureAppendable {
    private final OutputStream out;
    private final Charset charset;

    public OutputStreamPureAppendable(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    public OutputStreamPureAppendable(OutputStream out) {
        this(out, Charset.defaultCharset());
    }

    public static OutputStreamPureAppendable from(OutputStream out, Charset charset) {
        return new OutputStreamPureAppendable(out, charset);
    }

    public static OutputStreamPureAppendable from(OutputStream out) {
        return new OutputStreamPureAppendable(out);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public OutputStreamPureAppendable append(CharSequence csq) {
        try {
            this.out.write(csq.toString().getBytes(this.charset));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append char sequence.", e);
        }
        return this;
    }

    @Override
    public OutputStreamPureAppendable append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public OutputStreamPureAppendable append(char c) {
        return this.append(String.valueOf(c));
    }

    @Override
    public OutputStream getUnderlyingObject() {
        return this.out;
    }
}

