/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.container;

import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pl.mjaron.etudes.IPureAppendable;

public class WrappingPureAppendable
implements IPureAppendable {
    @NotNull
    private final Appendable appendable;

    public WrappingPureAppendable(@NotNull Appendable appendable) {
        this.appendable = appendable;
    }

    public static WrappingPureAppendable from(Appendable appendable) {
        return new WrappingPureAppendable(appendable);
    }

    @Override
    @Contract(value="_->this")
    @NotNull
    public IPureAppendable append(CharSequence csq) {
        try {
            this.appendable.append(csq);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append char sequence.", e);
        }
        return this;
    }

    @Override
    @Contract(value="_,_,_->this")
    @NotNull
    public IPureAppendable append(CharSequence csq, int start, int end) {
        try {
            this.appendable.append(csq, start, end);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append char sequence with given range.", e);
        }
        return this;
    }

    @Override
    @Contract(value="_->this")
    @NotNull
    public IPureAppendable append(char c) {
        try {
            this.appendable.append(c);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append char.", e);
        }
        return this;
    }

    @Override
    @NotNull
    public Appendable getUnderlyingObject() {
        return this.appendable;
    }
}

