/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import pl.mjaron.etudes.IRandomIterator;

public class CachingRandomIteratorWrapper<T>
implements IRandomIterator<T> {
    private final Iterator<T> it;
    private final ArrayList<T> cache = new ArrayList();
    private int pos = -1;

    public CachingRandomIteratorWrapper(Iterator<T> it) {
        this.it = it;
    }

    public boolean tryReadToCache() {
        if (!this.it.hasNext()) {
            return false;
        }
        this.cache.add(this.it.next());
        return true;
    }

    public boolean tryReadToCache(int pos) {
        while (this.cache.size() <= pos) {
            if (this.tryReadToCache()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(int position) {
        if (position < -1) {
            throw new RuntimeException("Cannot set position with index lower than -1. Current position: " + this.pos + ", requested position:" + position);
        }
        if (!this.tryReadToCache(position)) {
            throw new RuntimeException("Cannot increment the " + CachingRandomIteratorWrapper.class.getSimpleName() + " object: Underlying object doesn't have such elements count. Current position: " + this.pos + ", requested position: " + position + ", cached elements count: " + this.cache.size());
        }
        this.pos = position;
    }

    @Override
    public void increment(int count) {
        this.setPosition(this.pos + count);
    }

    @Override
    public void increment() {
        this.increment(1);
    }

    @Override
    public void decrement(int count) {
        this.setPosition(this.pos - count);
    }

    @Override
    public void decrement() {
        this.decrement(1);
    }

    @Override
    public T getCurrent() {
        return this.cache.get(this.pos);
    }

    @Override
    public boolean hasNext() {
        return this.tryReadToCache(this.pos + 1);
    }

    @Override
    public T next() {
        this.increment();
        return this.getCurrent();
    }
}

