/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.etudes.iterator;

import pl.mjaron.etudes.IRandomAccess;
import pl.mjaron.etudes.IRandomIterator;

public class RandomAccessIteratorWrapper<T>
implements IRandomIterator<T> {
    private final IRandomAccess<T> randomAccess;
    private int pos = -1;

    public RandomAccessIteratorWrapper(IRandomAccess<T> randomAccess) {
        this.randomAccess = randomAccess;
    }

    @Override
    public T getCurrent() {
        return this.randomAccess.get(this.pos);
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(int position) {
        this.pos = position;
    }

    @Override
    public void increment(int count) {
        this.pos += count;
    }

    @Override
    public void increment() {
        this.increment(1);
    }

    @Override
    public void decrement(int count) {
        this.pos -= count;
    }

    @Override
    public void decrement() {
        this.decrement(1);
    }

    @Override
    public boolean hasNext() {
        return this.randomAccess.size() > this.pos + 1;
    }

    @Override
    public T next() {
        this.increment();
        return this.getCurrent();
    }
}

